/* Sample solution for NWERC'06: Mountopia's Airport
 * Author: Per Austrin
 * Algorithm: Use observation that mountain height at left point should be
 *            as close as possible to height at right point, try all pairs
 *            of segments for the left and right points.
 */


/* Warning!
 * This solution is incorrect (observation above is false)!  It fails
 * for e.g. the following case:
 *
 * 4 8
 * 0 0
 * 4 2
 * 7 2
 * 12 7
 *
 * The correct answer is 11.5.
 *
 * While this solution was one of the official judge solutions for
 * this problem, the official test data used does not contain any
 * cases such as the one above (so the test data used in the contest
 * was incomplete, but not incorrect).
 *
 *
 * / Per Austrin, Head Judge, NWERC 2006
 *   2006-11-27
 *
 */

#include <cstdio>
#include <algorithm>

using namespace std;

int main(void) {
  int t;
  scanf("%d", &t);
  double ansX, ansY;
  while (t--) {
    int n, L, x[567], y[567];
    scanf("%d%d", &n, &L);
    for (int i = 0; i < n; ++i) {
      scanf("%d%d", x+i, y+i);
      if (i > 0 && x[i] == x[i-1]) printf("bad case ");
    }    
    double ans = 1e50;
    for (int i = 1; i < n; ++i) {
      double miny = 1e30, totA = 0;
      int dy1 = y[i]-y[i-1], dx1 = x[i]-x[i-1];
      for (int j = i; j < n; miny <?= y[j++]) {
	int diff = L-(x[j-1]-x[i-1]), dY = y[j-1]-y[i-1];
	int dy2 = y[j]-y[j-1], dx2 = x[j]-x[j-1];
	int disc = dy1*dx2 - dy2*dx1;
	int l = max(0, -diff), r = min(dx1, dx2-diff);
	if (i != j) totA += dx2*(y[j]+y[j-1]);
	if (l > r) continue;
	double t = l >? (disc ? (1.0*dx1*(dY*dx2+diff*dy2))/disc : l) <? r;
	double x1 = x[i-1]+t, y1 = y[i-1]+t*dy1/dx1;
	double x2 = x1+L, y2 = y[j-1]+(diff+t)*dy2/dx2;
	double yv = min(miny, min(y1, y2));
	double cand = (totA + (x[i]-x1)*(y[i]+y1) - (x[j]-x2)*(y[j]+y2))/2 - yv*L;
	if (cand < ans) 
	  ansX = x1, ansY = yv;
	ans <?= (totA + (x[i]-x1)*(y[i]+y1) - (x[j]-x2)*(y[j]+y2))/2 - yv*L;
      }
    }
    printf("%.6lf\n", ans);
    fprintf(stderr, "%lf %lf\n", ansX, ansY);
  }
  return 0;
}
