/*
  [NWERC'06] SETSTACK COMPUTER
  by: Jan Kuipers
*/

using namespace std;

#include <iostream>
#include <string>
#include <set>
#include <map>
#include <stack>
#include <vector>

#define ALL(x) x.begin(),x.end()
#define FOREACH(it,x) for(Set::iterator it=x.begin(); it!=x.end(); it++)

typedef set<int> Set;

map<Set,int> IDcache;
vector<Set> Setcache;
stack<int> s;

int ID (Set x) {
  if (IDcache.count(x)) return IDcache[x];
  Setcache.push_back(x);
  return IDcache[x]=Setcache.size()-1;
}

int main () {

  int runs;
  cin >> runs;

  while (runs--) {
    s=stack<int>();
    int N;
    cin >> N;
    for (int i=0; i<N; i++) {
      string op;
      cin >> op;

      if (op=="PUSH")
	s.push(ID(Set()));
      else if (op=="DUP")
	s.push(s.top());
      else {
	Set x1=Setcache[s.top()]; s.pop();
	Set x2=Setcache[s.top()]; s.pop();
	Set x;
	
	if (op=="UNION")
	  set_union (ALL(x1),ALL(x2),inserter(x,x.begin()));
	if (op=="INTERSECT")
	  set_intersection (ALL(x1),ALL(x2),inserter(x,x.begin()));
	if (op=="ADD") {
	  x=x2;
	  x.insert(ID(x1));
	}
	if (op=="X") 
	  FOREACH(i,x1) FOREACH(j,x2) {
	  Set tmp;
	  tmp.insert(*i);
	  tmp.insert(*j);
	  x.insert(ID(tmp));
	}
	
	s.push(ID(x));
      }
      
      cout << Setcache[s.top()].size() << endl;
    }

    cout << "***" << endl;
  }

  return 0;  
}
