#ifndef H_CORR_H
#define H_CORR_H

#ifdef __CPLUSPLUS
extern "C" {
#include <sys/varargs.h>
}
#include <cstdio>
#else
#include <sys/varargs.h>
#include <stdio.h>
#endif


const int EXIT_AC = 0;
const int EXIT_WA = 1;
const int EXIT_PE = 2;
const int EXIT_JUDGEERR = 3;
const int EXIT_INPUTERR = 4;

#define USAGE "%s: team_out judge_out\n"

FILE *teamout, *judgeout;

void report_error(char *err, ...) {
   va_list pvar;
   va_start(pvar, err);
   vfprintf(stdout, err, pvar);
   fprintf(stdout, "\n");
   exit(EXIT_WA);
}

void init_io(int argc, char **argv) {

   if(argc != 3) {
     fprintf(stdout, USAGE, argv[0]);
     exit(EXIT_JUDGEERR);
   }


   if ((teamout = fopen(argv[1], "r")) == 0) {
     fprintf(stdout, "%s: failed to open %s\n", argv[0], argv[1]);
     exit(EXIT_JUDGEERR);
   }
   
   if ((judgeout = fopen(argv[2], "r")) == 0) {
     fprintf(stdout, "%s: failed to open %s\n", argv[0], argv[2]);
     exit(EXIT_JUDGEERR);
   }
}

#endif /* H_CORR_H */
