% 2010-11-10 Magnus Burenius

% Rotates an affine reconstruction to the coordinate system of the last
% camera. Then rotates it to get the same up direction as MATLAB's
% coordinate system.

function [P1, X1 ] = RotateReconstruction( P, X )

m1 = P(end-1,:);
m2 = P(end  ,:);

m1 = m1/norm(m1);
m2 = m2/norm(m2);
m3 = cross(m1,m2);
m3 = m3/norm(m3);

% Rotate to system of last camera:
R1 = [m1;m2;m3];

% Rotate to get same up direction as MATLAB:
R2 = [ 0  0 1;
      -1  0 0;
       0 -1 0];

R = R2*R1;

%P1 = P * inv(R);
P1 = P / R;
X1 = R * X;


end