/* Program som testar Stavas API. Det frvntar sig ett ord
   per rad och matar ut ord som anses vara felstavade.
   Rttstavningsfrslag ges.
   Fr korrekta ord ges sammansttningsanalys.

   Copyright (C) Viggo Kann 2015-03-17
   */

/******************************************************************************

    This file is part of Stava.

    Stava is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Stava is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Stava.  If not, see <http://www.gnu.org/licenses/>.

******************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "libstava.h"

int main(void)
{ char buf[1001];
  utf8locale = 1;
#if DEFAULTCODE==4 /* UTF8CODE=4 */
  utf8locale = 1;
#endif
  if (!StavaReadLexicon(LIBPATH,1,1,1,1,1,1,(const unsigned char *) ",")) {
    fprintf(stderr, "Kan inte initiera Stava\n");
    exit(1);
  }
  xGenerateCompounds = 1;
  while (fgets(buf, 1000, stdin)) {
    buf[strcspn(buf, "\r\n")] = '\0';
    if (utf8locale == 1) {
      char tmpbuf[1001];
      tmpbuf[1000] = '\0';
      utf8string2iso(tmpbuf, 1000, (unsigned char *) buf);
      strcpy(buf, tmpbuf);
    }
    if (!StavaWord((unsigned char *) buf)) {
      unsigned char *corrections = StavaCorrectWord((unsigned char *) buf);
      if (corrections) {
	PrintLocale(stdout, buf);
	PrintLocale(stdout, ": ");
	PrintLocale(stdout, (char *) corrections);
	PrintLocale(stdout, "\n");
	free(corrections);
      }
    }
    else {
      char result[10000], *resp;
      StavaGetAllCompounds((unsigned char *) result, (unsigned char *) buf);
      PrintLocale(stdout, buf);
      PrintLocale(stdout, ":)");
      for (resp = result; (char)*resp; resp += strlen(resp) + 1) {
	PrintLocale(stdout, " ");
	PrintLocale(stdout, resp);
      }
      PrintLocale(stdout, "\n");
    }
  }
  return 0;
}
