/* Program som testar Stavas API inklusive SplitCompound. Det förväntar sig ett ord
   per rad och matar ut ord som anses vara felstavade.
   Rättstavningsförslag ges.

   Copyright (C) Viggo Kann 2015-03-08
   */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "libstava.h"
#include "split_compounds.h"

int main(void)
{ char buf[1001];
#if DEFAULTCODE==4 /* UTF8CODE=4 */
  utf8locale = 1;
#endif
  if (!StavaReadLexicon(LIBPATH,1,1,0,0,0,1,(const unsigned char *) ",")) {
    fprintf(stderr, "Kan inte initiera Stava\n");
    exit(1);
  }
  StavaAddWord((unsigned char *) "whiteboard", 'E'); /* testa att lägga till några ord som inte ska anses sammansatta */
  StavaAddWord((unsigned char *) "ellinor", 'E');
  StavaAddWord((unsigned char *) "ellen", 'E');
  StavaAddWord((unsigned char *) "chokladfabrik", 'E');
  StavaAddWord((unsigned char *) "fotbolls", 'F');
#ifndef SPLITCOMPOUNDSCCNOTUSED
  InitSplitCompoundsData(LIBPATH);
#endif
  xGenerateCompounds = 1;
  while (fgets(buf, 1000, stdin)) {
    buf[strcspn(buf, "\r\n")] = '\0';
    if (utf8locale == 1) {
      char tmpbuf[1001];
      tmpbuf[1000] = '\0';
      utf8string2iso(tmpbuf, 1000, (unsigned char *) buf);
      strcpy(buf, tmpbuf);
    }
    if (*buf == '+') {
      StavaAddWord((unsigned char *) buf+1, 'E');
    } else
    if (!StavaWord((unsigned char *) buf)) {
      unsigned char *corrections = StavaCorrectWord((unsigned char *) buf);
      if (corrections) {
	PrintLocale(stdout, buf);
	PrintLocale(stdout, ": ");
	PrintLocale(stdout, (char *) corrections);
	PrintLocale(stdout, "\n");
	free(corrections);
      }
    }
    else {
      char result[1000];
      StavaAnalyzeCompound((unsigned char *) result, (unsigned char *) buf);
      PrintLocale(stdout, buf);
      PrintLocale(stdout, ":) ");
      PrintLocale(stdout, result);
      PrintLocale(stdout, "\n");
    }
  }
  return 0;
}
