/* Rttstavningsprogram. Version 2.66 2015-03-08
   Copyright (C) 1990-2015
   Joachim Hollman och Viggo Kann
   joachim@nada.kth.se viggo@nada.kth.se
*/

/******************************************************************************

    This file is part of Stava.

    Stava is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Stava is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Stava.  If not, see <http://www.gnu.org/licenses/>.

******************************************************************************/

#ifdef TRYALLRULES
#define TAGMAXLENGTH 150
#define MAXNOOFTAGS 20
extern char tag[MAXNOOFTAGS][TAGMAXLENGTH];
extern int nooftags;

/* CheckSuffixAndTag kollar om word innehller suffix i suffixtabellen, p samma stt
som CheckDuffix, men gr alltid igenom alla regler och taggar dessutom.
Antalet mjliga tolkningar returneras. */
extern int CheckSuffixAndTag(const unsigned char *word_prefix, const unsigned char *word);
#endif

/* InitSuf initierar suffixtabellen och returnerar 0 om det gick bra. */
extern int InitSuf(const char *SLfilename);
/* CheckSuffix kollar om word innehller suffix i suffixtabellen. Fr varje
rad i suffixtabellen som stmmer verens kollas att ordet finns i ordlistan
om suffixet byts ut mot alla kollsuffix i s fall returneras 1. Annars
returneras 0. */
extern int CheckSuffix(const unsigned char *word, int tryallrules, int compoundSearch);
#ifdef DEBUG
/* WriteSuffixList skriver ut suffixtabellen (i avlusningssyfte) */
extern void WriteSuffixList(void);
#endif

