/***************************************************************************
                                 evinit.cpp
                             -------------------
                               Wed Nov 27 2002
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "evinit.hpp"

#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/util/XMLString.hpp> //is this ever used?

#include "internal.hpp"
#include "databank.hpp"
#include "evexp.hpp"
#include "evutil.hpp"
#include "process.hpp"
#include "xmlconf.hpp"

static bool XMLIsStarted = false, configured = false;


void DoConfiguration(const std::string &configFile) {
    if (configured) {
        EvExp e;
        e.section = "Main Configuration";
        e.error = "Internal Error";
        e.data = "Already configured, (called DoConfiguration() twice?)";
        throw e;
    }
  
    Varprocessor *varprc = dumdidum::getVarprocessor(); /*see process.hpp on dumdidum*/
    Configurator evconfig(getDatabank(), varprc);
    CfgFileReader evCfgFileRD(configFile, &evconfig);
    evCfgFileRD.walk();
    configured = true;
  
    // General functions
    varprc->addFunc("do", do_);
    varprc->addFunc("ignore", ignore);
    varprc->addFunc("exenext", exenext);
    varprc->addFunc("exenextelse", exenextelse);
    // Setter functions
    varprc->addFunc("setdbl", setdbl);
    varprc->addFunc("setstr", setstr);
    // Compare functions
    varprc->addFunc("eqstr", eq_str);
    varprc->addFunc("eqdbl", eq_dbl);
    varprc->addFunc("leq", leq_dbl);
    // Convertion functions
    varprc->addFunc("str2int", string2int);
    varprc->addFunc("str2dbl", string2double);
    varprc->addFunc("int2str", int2string);
    varprc->addFunc("dbl2str", double2string);
    // Math functions
    varprc->addFunc("div", divide);
    varprc->addFunc("mul", multiply);
    varprc->addFunc("sub", subtract);
    varprc->addFunc("add", add);
    varprc->addFunc("mod", modulus);
    varprc->addFunc("inc", increment);
    varprc->addFunc("inc", increment_byval);
    varprc->addFunc("dec", decrement);
    varprc->addFunc("dec", decrement_byval);
    varprc->addFunc("rand", rand_con);
    // String functions
    varprc->addFunc("concat", concat_2);
    varprc->addFunc("concat", concat_3);
    varprc->addFunc("concat", concat_4);
    varprc->addFunc("regex", match_regex);
    varprc->addFunc("substr", match_substr);
    varprc->addFunc("start", match_start);
    // Counter variable functions
    varprc->addFunc("cnt", cnt1);
    varprc->addFunc("cnt", cnt2);
    varprc->addFunc("cntmap", cntmap);
    varprc->addFunc("lookupcnt", lookupcnt1);
    varprc->addFunc("lookupcnt", lookupcnt2);
    // String variable functions
    varprc->addFunc("var", var1);
    varprc->addFunc("var", var2);
    varprc->addFunc("varmap", varmap);
    varprc->addFunc("lookup", lookup1);
    varprc->addFunc("lookup", lookup2);
    // File functions
    varprc->addFunc("in", in);
    varprc->addFunc("filter", filter);
    varprc->addFunc("out", out);
    varprc->addFunc("outfile_xml", outfilexml);
    varprc->addFunc("infile_xml", infilexml);
    varprc->addFunc("infile_plain", infileplain);
    varprc->addFunc("stdin_plain", stdinplain);
    varprc->addFunc("filter_plain", filterplain);
    // Read functions
    varprc->addFunc("field", field_1);
    varprc->addFunc("field", field_2);
    varprc->addFunc("field", field_3);
    varprc->addFunc("field", field_4);
    varprc->addFunc("field", field_5);
    varprc->addFunc("xfield", xfield);
    // Filter functions
    varprc->addFunc("filter", basic_filter);
    // Output functions
    varprc->addFunc("print", cout_print);
    varprc->addFunc("progress", cout_progress);
    varprc->addFunc("output_int", out_int);
    varprc->addFunc("output_dbl", out_dbl);
    varprc->addFunc("output_str", out_str);
    varprc->addFunc("output_int", out_intmap);
    varprc->addFunc("output_dbl", out_dblmap);
    varprc->addFunc("output_str", out_strmap);
    varprc->addFunc("output_all_int", out_allint);
    varprc->addFunc("output_all_dbl", out_alldbl);
    varprc->addFunc("output_all_str", out_allstr);
    // Logic functions
    varprc->addFunc("and", logic_and_2);
    varprc->addFunc("and", logic_and_3);
    varprc->addFunc("and", logic_and_4);
    varprc->addFunc("not", logic_not);
    varprc->addFunc("or", logic_or_2);
    varprc->addFunc("or", logic_or_3);
    varprc->addFunc("or", logic_or_4);
    // Example functions
    varprc->addFunc("example", basic_example);
    varprc->addFunc("majority", basic_majority5);
    // Dummy functions
    varprc->addFunc("_eq", bool_dummy2);
    varprc->addFunc("_set", bool_dummy2);
}

void DoEvaluation() {
    dumdidum::getVarprocessor()->processEntries(); /*see process.hpp on dumdidum*/
    getDatabank()->flushOutputBuffers();
}

void XMLEngineStart() {
    if (XMLIsStarted) {
        EvExp e;
        e.section = "XML Initialization";
        e.error = "Internal Error";
        e.data = "XMLEngine already started, (called XMLEngineStart() twice?)";
        throw e;
    }
     
    try {
        XMLPlatformUtils::Initialize();
    }
     
    catch (const XMLException& toCatch) {
        EvExp e;
        e.section = "XML Initialization";
        e.error = "Xerces Error during initialization";
        e.data = XML2Ch(toCatch.getMessage()).toStr();
        throw e;
    }
     
    XMLIsStarted = true;
}


void XMLEngineStop() {    
    XMLPlatformUtils::Terminate();
    if (!XMLIsStarted) {
        EvExp e;
        e.section = "XML Initialization";
        e.error = "Internal Error";
        e.data = "XMLEngine already stopped, (called XMLEngineStop() twice?)";
        throw e;
    }
    XMLIsStarted = false;
}
