/***************************************************************************
                                  functor.cpp
                             -------------------
                               Sat Oct 19 2002
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "functor.hpp"
#include "process.hpp"

#include "parser/parse.hpp"

template<>
bool isTokenConst<bool>(NodeInfo::Node* arg) {
     if (!arg) {
	  return false;
     }
     return arg->type == NodeInfo::T_BOOL;
}

template<>
bool isTokenConst<double>(NodeInfo::Node* arg) {
     if (!arg) {
	  return false;
     }
     return (arg->type == NodeInfo::T_INT) || (arg->type == NodeInfo::T_DBL);
}

template<>
bool isTokenConst<std::string>(NodeInfo::Node* arg) {
     if (!arg) {
	  return false;
     }
     return arg->type == NodeInfo::T_STR;
}

template<>
bool getTokenConst(NodeInfo::Node* argdata) {
     ParseResult::check_type(argdata, NodeInfo::T_BOOL);
     return argdata->data.boolean;
}

template<>
double getTokenConst(NodeInfo::Node* argdata) {
     if (!isTokenConst<double>(argdata)) {
	  ParseResult::check_type(argdata, NodeInfo::T_DBL);
     }
     if (argdata->type == NodeInfo::T_INT) {
	  return (double)argdata->data.integer;
     }
     else {
	  return argdata->data.dbl;
     }
}

static std::string escaped_filter(std::string s) {
    std::string::size_type pos = s.find("\\");
    while (pos != std::string::npos) {
	if (s.length() < pos + 1)
	    break;
	if (s[pos + 1] == 'n')
	    s.replace(pos, 2, "\n");
	else if (s[pos + 1] == 't')
	    s.replace(pos, 2, "\t");
	pos = s.find("\\", pos + 1);
    }
    return s;
}

template<>
std::string getTokenConst(NodeInfo::Node* argdata) {
     ParseResult::check_type(argdata, NodeInfo::T_STR);
     std::string ret = escaped_filter(argdata->data.str);
     return ret;
}
