/***************************************************************************
                                  internal.cpp
                             -------------------
                               Tue February 4 2002
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "internal.hpp"

#include <cstdlib>  // rand
#include <sstream>
#include <iostream>

#include <boost/regex.hpp>

#include "databank.hpp"
#include "insrc.hpp"  // DSource, EvFilter
#include "outxml.hpp" // XOutput

const char *const global_cont = "global";
const double epsilon = 1.0001;

// General functions

bool do_(bool b) {
     return b;
}

bool ignore(bool b) {
     return true;
}

bool exenext(bool b) {
    void set_skip(bool);  // defined in execute.cpp
    set_skip(!b);
    return true;
}

bool exenextelse(bool b) {
    void set_skip(bool);  // defined in execute.cpp
    set_skip(!b);
    void set_long_skip(bool); // defined in execute.cpp
    set_long_skip(b);
    return true;
}


// Setter functions

bool setdbl(double &i, double j) {
    i = j;
    return true;
}

bool setstr(std::string &s, std::string t) {
    s = t;
    return true;
}

// Compare functions

bool eq_str(std::string str1,std::string str2) {
     return str1 == str2;
}

bool eq_dbl(double i1, double i2) {
     return (i1 >= i2 / epsilon) && (i1 <= i2 * epsilon);
}

bool leq_dbl(double d1, double d2) {
     return (d1 <= d2 * epsilon);
}

// Convertions functions

int double2int(double d) {
     return (int)(d + 0.5);
}

double string2int(std::string s) {
     std::istringstream is(s);
     int i = 0;
     is >> i;
     return (double)i;
}

double string2double(std::string s) {
     std::istringstream is(s);
     double d = 0;
     is >> d;
     return d;
}

std::string int2string(double num) {
     std::ostringstream os;
     os << double2int(num); 
     return os.str();
}

std::string double2string(double num) {
     std::ostringstream os;
     os << num;
     return os.str();
}


// Math functions

double divide(double n, double d) {
     return n / d;
}

double multiply(double n, double d) {
     return n * d;
}

double subtract(double n, double d) {
     return n - d;
}

double add(double n, double d) {
     return n + d;
}

double modulus(double n, double d) {
     return (double)(double2int(n) % double2int(d));
}

bool increment(double &cnt) {
     ++cnt;
     return true;
}

bool increment_byval(double &cnt, double val) {
     cnt = cnt + val;
     return true;
}

bool decrement(double &cnt) {
     --cnt;
     return true;
}

bool decrement_byval(double &cnt, double val) {
     cnt = cnt - val;
     return true;
}

bool rand_con(double prob) {
     return ((int)prob >= ((int)rand() % 100));
}

// String functions

std::string concat_2(std::string s, std::string t) {
    return s + t;
}

std::string concat_3(std::string r, std::string s, std::string t) {
    return r + s + t;
}

std::string concat_4(std::string q, std::string r, std::string s, std::string t) {
    return q + r + s + t;
}

bool match_regex(std::string &result, const std::string buffer, const std::string expr) {
     boost::smatch wordMatch;
     boost::regex  regExpr(expr);
     if (boost::regex_search(buffer, wordMatch, regExpr)) {
	  result = wordMatch[0];
     }
     else {
	  result = "None";
     }
     return true;
}

bool match_substr(std::string &result, const std::string buffer, const std::string expr) {
     std::string::size_type pos = buffer.find(expr);
     if (pos != std::string::npos) {
	  result = expr;
     }
     return true;
}

bool match_start(std::string &result, const std::string buffer, const std::string expr) {
     if (buffer.compare(0, expr.length(), expr) == 0) {
	  result = expr;
     }
     return true;
}

// Counter variable functions

double& cnt2(std::string s, std::string cont) {
    return getDatabank()->giveCntRef(s, cont);
}

double& cnt1(std::string s) {
    return cnt2(s, global_cont);
}

double lookupcnt2(std::string s, std::string cont) {
    return getDatabank()->getCnt(s, cont);
}

double lookupcnt1(std::string s) {
    return lookupcnt2(s, global_cont);
}

const CntMap &cntmap(std::string cont) {
    return getDatabank()->getCntMap(cont);
}

// String variable functions

std::string& var2(std::string s, std::string cont) {
    return getDatabank()->giveVarRef(s, cont);
}

std::string& var1(std::string s) {
    return var2(s, global_cont);
}

std::string lookup2(std::string s, std::string cont) {
    return getDatabank()->getVar(s, cont);
}

std::string lookup1(std::string s) {
    return lookup2(s, global_cont);
}

const DataMap &varmap(std::string cont) {
    return getDatabank()->getVarMap(cont);
}

// File functions

DSource &in(std::string f) {
    DSource &d = getDatabank()->getBuffer(f);
    return d;
}

EvFilter& filter(std::string s) {
    return getDatabank()->getFilter(s);
}

XOutput& out(std::string s) {
    return getDatabank()->getOutBuffer(s);
}

bool outfilexml(std::string buffName, std::string fileName) {
     getDatabank()->addOutputBuffer(buffName, fileName);
     return true;
}

bool infileplain(std::string buffName, std::string fileName) {
     getDatabank()->addInputBuffer(buffName, fileName, "plain");
     return true;
}

bool infilexml(std::string buffName, std::string fileName) {
     getDatabank()->addInputBuffer(buffName, fileName, "xml");
     return true;
}

bool stdinplain(std::string buffName) {
     getDatabank()->addInputBuffer(buffName, "dummy", "stdin");
     return true;
}

bool filterplain(std::string filterName, std::string fileName) {
     getDatabank()->addFilter(filterName, fileName);
     return true;
}

// Read functions

static bool field_helper(DSource &buffer, std::string idelim, std::string edelim, std::vector<std::string> &v) {
     std::string s;
     while (!buffer.isExhausted()) {
	  s = buffer.getData();
	  
	  unsigned int i;
	  std::string::size_type pos = 0;
	  for(i = 0; i < v.size(); i++) {
	       std::string &f = i < v.size() - 1 ? idelim : edelim;
	       std::string::size_type oldpos = pos;
	       pos = s.find(f, pos);
	       if(pos == std::string::npos)
		    break;
	       v[i] = s.substr(oldpos, pos - oldpos);
	       pos++;
	  }
	  if(i != v.size()) {
	       buffer.dataSeen(0);
	       continue;
	  }
	  
	  buffer.dataSeen(pos);
	  return true;
     }
     return false;
}

bool field_1(DSource &buffer, std::string idelim, std::string edelim, std::string &var1) {
     std::vector<std::string> v(1);
     bool ret = field_helper(buffer, idelim, edelim, v);
     var1 = v[0];
     return ret;
}

bool field_2(DSource &buffer, std::string idelim, std::string edelim, std::string &var1, std::string &var2) {
     std::vector<std::string> v(2);
     bool ret = field_helper(buffer, idelim, edelim, v);
     var1 = v[0];
     var2 = v[1];
     return ret;
}

bool field_3(DSource &buffer, std::string idelim, std::string edelim, std::string &var1, std::string &var2, std::string &var3) {
     std::vector<std::string> v(3);
     bool ret = field_helper(buffer, idelim, edelim, v);
     var1 = v[0];
     var2 = v[1];
     var3 = v[2];
     return ret;
}

bool field_4(DSource &buffer, std::string idelim, std::string edelim, std::string &var1, std::string &var2, std::string &var3, std::string &var4) {
     std::vector<std::string> v(4);
     bool ret = field_helper(buffer, idelim, edelim, v);
     var1 = v[0];
     var2 = v[1];
     var3 = v[2];
     var4 = v[3];
     return ret;
}

bool field_5(DSource &buffer, std::string idelim, std::string edelim, std::string &var1, std::string &var2, std::string &var3, std::string &var4, std::string &var5) {
     std::vector<std::string> v(5);
     bool ret = field_helper(buffer, idelim, edelim, v);
     var1 = v[0];
     var2 = v[1];
     var3 = v[2];
     var4 = v[3];
     var5 = v[4];
     return ret;
}


bool xfield(DSource &buffer, std::string root, std::string datanode, std::string data1, std::string data2, std::string &var1, std::string &var2) {
     if(!buffer.isConfigurated()) {
	  DataMap meta;
	  meta["root"] = root;
	  meta["datanode"] = datanode;
	  meta["data1"] = data1;
	  meta["data2"] = data2;
	  buffer.configurate(meta);
     }
     return field_2(buffer, "\t", "\t", var1, var2);
}

// Filter functions

bool basic_filter(EvFilter &filter, std::string idelim, std::string edelim, std::string &var) {
     if (!filter.isConfigurated()) {
	  filter.configurate(idelim,edelim);
     }     
     DataMap::const_iterator iter = filter.getFiltdata().find(var);
     if (iter != filter.getFiltdata().end()) {
	  var = iter->second;
     }
     return true;
}

// Output functions

bool cout_print(std::string s) {
    std::cout << s;
    std::cout.flush();
    return true;
}

bool cout_progress(std::string s) {
    static int i = 1;
    int c = 10;

    if(!(i % (10 * c)))
	std::cout << i;
    if(!(i % c))
	std::cout << s;
    std::cout.flush();
    i++;
    return true;
}

bool out_int(XOutput &buffer, std::string varName, double varData, std::string section) {
     buffer.writevar(section, varName, double2int(varData));
     return true;
}

bool out_dbl(XOutput &buffer, std::string varName, double varData, std::string section) {
     buffer.writevar(section, varName, varData);
     return true;
}

bool out_str(XOutput &buffer, std::string varName, std::string varData, std::string section) {
     buffer.writevar(section, varName, varData);
     return true;
}

bool out_intmap(XOutput &buffer, const CntMap& intmap, std::string section) {
     for (CntMap::const_iterator iter = intmap.begin(); iter != intmap.end(); ++iter)
	  buffer.writevar(section, iter->first, double2int(iter->second));
     return true;
}

bool out_dblmap(XOutput &buffer, const CntMap& intmap, std::string section) {
     for (CntMap::const_iterator iter = intmap.begin(); iter != intmap.end(); ++iter)
	  buffer.writevar(section, iter->first, iter->second);
     return true;
}

bool out_strmap(XOutput &buffer, const DataMap& strmap, std::string section) {
     for (DataMap::const_iterator iter=strmap.begin();iter!=strmap.end();++iter)
	  buffer.writevar(section,iter->first,iter->second);
     return true;
}

bool out_allint(XOutput &buffer) {
     Databank *bank = getDatabank();
     for (CntConMap::const_iterator iter = bank->counterCons.begin(); iter != bank->counterCons.end(); ++iter) {
	  out_intmap(buffer, iter->second, iter->first);
     }
     return true;
}

bool out_alldbl(XOutput &buffer) {
     Databank *bank = getDatabank();
     for (CntConMap::const_iterator iter = bank->counterCons.begin(); iter != bank->counterCons.end(); ++iter) {
	  out_dblmap(buffer, iter->second, iter->first);
     }
     return true;
}

bool out_allstr(XOutput &buffer) {
     Databank *bank = getDatabank();
     for (VarConMap::const_iterator iter = bank->varCons.begin(); iter != bank->varCons.end(); ++iter) {
	  out_strmap(buffer, iter->second, iter->first);
     }
     return true;
}


// Logic functions

bool logic_not(bool logic) {
     return !logic;
}

bool logic_and_2(bool logic1, bool logic2) {
     return (logic1 && logic2);
}

bool logic_and_3(bool logic1, bool logic2, bool logic3) {
     return (logic1 && logic2 && logic3);
}

bool logic_and_4(bool logic1, bool logic2, bool logic3, bool logic4) {
     return (logic1 && logic2 && logic3 && logic4);
}

bool logic_or_2(bool logic1, bool logic2) {
     return (logic1 || logic2);
}


bool logic_or_3(bool logic1, bool logic2, bool logic3) {
     return (logic1 || logic2 || logic3);
}


bool logic_or_4(bool logic1, bool logic2, bool logic3, bool logic4) {
     return (logic1 || logic2 || logic3 || logic4);
}

// Example functions

bool basic_example(XOutput &buffer, std::string section, std::string exName, std::string kvar, std::string kvardata, std::string var1, std::string var1data, std::string var2, std::string var2data)
{
     buffer.writeexample(section,exName,kvar,kvardata,var1,var1data,var2,var2data);
     return true;
}

bool basic_majority5(std::string &major, std::string var1, std::string var2, std::string var3, std::string draw)
{
     CntMap occurs;
     DataVector vars;
     std::string majvar;
     double majcnt = 0;
     
     vars.push_back(var1);
     vars.push_back(var2);
     vars.push_back(var3);
     for(DataVector::const_iterator iter = vars.begin(); iter != vars.end(); ++iter) {
	  double &cnt = occurs[*iter];
	  ++cnt;
     }
     
     for(CntMap::const_iterator iter = occurs.begin();iter != occurs.end(); ++iter) {
	  if (iter->second > majcnt) {
	       majvar = iter->first;
	       majcnt = iter->second;
	  }
     }
     
     occurs.erase(majvar);
     
     for(CntMap::const_iterator iter = occurs.begin(); iter != occurs.end(); ++iter) {
	  if (iter->second == majcnt) {
	       major = draw;
	       return true;
	  }
     }
     major = majvar;
     return true;
}

// Dummy functions

bool bool_dummy2(double dummy1, double dummy2) {
     return true;
}

