/***************************************************************************
                                  mydomparser.hpp
                             -------------------
                               Sat Oct 19 2002
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MYDOMPARSER_H
#define MYDOMPARSER_H

#include <xercesc/parsers/XercesDOMParser.hpp>
#include <xercesc/dom/DOM.hpp>
#include <xercesc/internal/XMLScanner.hpp>

#include <string>
#include <map>

XERCES_CPP_NAMESPACE_USE

struct LineCol {
     int line;
     int column;
     std::string filename;
};
typedef std::map<const DOMNode*, LineCol> NodePos;

/**
 * For each DOM element found, the line number, column number and
 * filename is saved in the map specified in the constructor.
 */
class MyDOMParser : public XercesDOMParser {     
public:
     MyDOMParser(NodePos& np) : nodepos_(np){
     }

     void startElement(const XMLElementDecl& elemDecl,
		       const unsigned int urlId,
		       const XMLCh *const elemPrefix,
		       const RefVectorOf<XMLAttr>& attrList,
		       const unsigned int attrCount,
		       const bool isEmpty,
		       const bool isRoot) {
	  XercesDOMParser::startElement(elemDecl, urlId, elemPrefix, attrList, 
					attrCount, isEmpty, isRoot);	  
	  
	  DOMNode* node = getCurrentNode();
	  XMLScanner* scanner    = getScanner();
	  const Locator* locator = scanner->getLocator();

	  LineCol lc;
	  lc.line = locator->getLineNumber();
	  lc.column = locator->getColumnNumber();
	  lc.filename = XMLString::transcode(locator->getSystemId());
	  nodepos_.insert(std::make_pair(node, lc));
     }
private:
     NodePos& nodepos_;

};

#endif
