/***************************************************************************
                                  myfunc.hpp
                             -------------------
                               Sat Oct 19 2002
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "process.hpp"
#include "databank.hpp"    // CntMap, getDatabank() mm
#include <iostream>
#include <cmath>


bool phonly(std::string &r,     // return value
	    std::string input,  // input string, i.e. APB|NPB|NPI
	    std::string type)   // type of phrase, i.e. NP
{
    r = "";

    unsigned int pos = input.find(type);
    while(pos != std::string::npos)
    {
	r  += input[pos + type.length()];
	pos = input.find(type, pos + 1);
    }

    return true;
}

bool ph(std::string &r,     // return value
	std::string input,  // input string, i.e. APB|NPB|NPI
	std::string type,   // type of phrase, i.e. NP
	int lev)   // level (0 => NPI, 1 => NPB, >1 => None in example above)
{
    r = "None";

    unsigned int pos = input.rfind(type);
    for(int i = 0; i < lev && pos != std::string::npos; i++)
    {
	if(pos == 0)
	{
	    pos = std::string::npos;
	    break;
	}
	pos = input.rfind(type, pos - 1);
    }

    if(pos != std::string::npos)
	r = input.substr(pos, type.length() + 1);

    return true;
}

double precision(double corr, double found)
{
    return corr / found * 1000;
}

double recall(double corr, double tot)
{
    return corr / tot * 1000;
}

double accuracy(double corr, double tot)
{
    return corr / tot * 1000;
}

double fscore(double prec, double rec)
{
    return (2.0 * prec * rec) / (prec + rec);
}

double stddev(double n, double sum, double sum_sq)
{
    return sqrt((sum_sq - 1.0/n*sum*sum)/(n-1));
}

bool summarizeavg(double n)
{
    std::vector<CntMap *>      categ;
    std::vector<std::string>   names;
    std::vector<double>  stddevs;

    CntConMap::iterator con = getDatabank()->counterCons.begin();
    for(; con != getDatabank()->counterCons.end(); ++con)
    {
	CntMap &m = con->second;
	CntMap::iterator it = m.begin();
	for(; it != m.end(); ++it)
	{
	    const std::string &name = it->first;
	    if(name.substr(name.length() - 2, 2) != "sq")
	    {
		CntMap::iterator iter = m.find(name + "_sq");
		if(iter != m.end())
		{
		    categ.push_back(&con->second);
		    names.push_back(name);
		    stddevs.push_back(stddev(n, it->second, iter->second));
		    it->second /= n;
		}
	    }
	}
	for(unsigned int i = 0; i < names.size(); i++)
	    categ[i]->insert(CntMap::value_type(names[i] + "_std", stddevs[i]));
    }
    return true;
}

bool comparerel(double n)
{
    std::vector<CntMap *>      categ;
    std::vector<std::string>   names;
    std::vector<double>  rels;

    CntConMap::iterator con = getDatabank()->counterCons.begin();
    for(; con != getDatabank()->counterCons.end(); ++con)
    {
	CntMap &m = con->second;
	CntMap::iterator it = m.begin();
	for(; it != m.end(); ++it)
	{
	    const std::string &name = it->first;
	    if(name.substr(name.length() - 2, 2) != "sq")
	    {
		CntMap::iterator iter = m.find("comp_" + name);
		if(iter != m.end())
		{
		    categ.push_back(&con->second);
		    names.push_back(name);
		    rels.push_back(1000.0 - it->second / iter->second * 1000.0);
		}
	    }
	}
	for(unsigned int i = 0; i < names.size(); i++)
	    categ[i]->insert(CntMap::value_type(names[i] + "_rel", rels[i]));
    }
    return true;
}

static void register_func()
{
    Varprocessor &vp = *dumdidum::getVarprocessor(); /*see process.hpp on dumdidum*/

    vp.addFunc("ph", phonly);
    vp.addFunc("precision", precision);
    vp.addFunc("recall", recall);
    vp.addFunc("accuracy", accuracy);
    vp.addFunc("fscore", fscore);
    vp.addFunc("stddev", stddev);
    vp.addFunc("summarizeavg", summarizeavg);
    vp.addFunc("comparerel", comparerel);
}

static struct Handler
{
    Handler() { register_func(); }
} handler;


