/***************************************************************************
                                  outxml.hpp
                             -------------------
                               Wed Dec 4 2002
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef OUT_XML_H
#define OUT_XML_H

#include <map>
#include <string>

#include <xercesc/dom/DOM.hpp>
#include <xercesc/framework/LocalFileFormatTarget.hpp>

XERCES_CPP_NAMESPACE_USE

typedef std::map<std::string, DOMElement*> SectionMap;

/**
 * Result file output module 
*/
class XOutput
{
public:
     XOutput(const std::string &filename);

     /* Writes the DOM document to disc*/
     void flush();
     
     /* Function which adds an example structure to a specfied section of the document */
     void writeexample(const std::string &section, const std::string &subsection, const std::string &mainvar, const std::string &mainvardata, const std::string &var1, const std::string &var1data, const std::string &var2, const std::string &var2data);
     
     /* Function which adds a integer variable to a specified section of the document */
     void writevar(const std::string &section, const std::string &attrname, const int data);

     /* Function which adds a double variable to a specified section of the document */
     void writevar(const std::string &section, const std::string &attrname, const double data);
     
     /* Function which adds a string variable to a specified section of the document */
     void writevar(const std::string &section, const std::string &attrname, const std::string &data);
     
     ~XOutput();
private:
     /* Creates a new section in the DOM document */
     DOMElement* createSection(const std::string &section);
     
     /* Returns the root node of a section */
     DOMElement* getSectionElement(const std::string &section);
     
     DOMDocument *doc_;
     XMLFormatTarget *filetarget_;
     DOMImplementation *impl_;
     DOMElement *root_;
     SectionMap sections_;
     std::string filename_;
};

#endif
