/******************************************************************************

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

******************************************************************************/

#ifndef ALLOC_H
#define ALLOC_H

#include "node.hpp"
#include "strpool.hpp"

#include <deque>

namespace NodeInfo {

     class Alloc;
}

/**
 * Allocates the nodes for the parse tree
 */
class NodeInfo::Alloc {
public:
     Alloc(Parse::StrPool &p) : pool(p) {}
     ~Alloc();

     Node* alloc_str(const char *s, const char *name);
     Node* alloc_int(int i, const char *name);
     Node* alloc_dbl(double d, const char *name);
     Node* alloc_tmplref(int i, const char *name);
     Node* alloc_bool(bool b, const char *name);
     Node* alloc_call(const char *s, Node* l, const char *name);
     Node* alloc_list(Node* h);
     Node* alloc_line(Node* h, const char *name);
     Node* clone_subtree(Node* node);

protected:
     Node* alloc();
     Parse::StrPool &pool;
     std::deque<Node> mem;
};

#endif
