%{
#include <stdlib.h>
#include "error.hpp"
#include "node.hpp"
#include "parser.tab.h"
#include "scan_parse.hpp"
#include "control.hpp"

#undef YY_INPUT
#define YY_INPUT(buf, res, max) (res = do_input(buf, max))
#define YY_DECL int yylex(YYSTYPE *yylval, YYLTYPE *yylloc, void *control)

#define NEWPOS PARM->begin=PARM->end; PARM->end+=yyleng; yylloc->first_line=PARM->line; yylloc->last_line=PARM->line; yylloc->first_column=PARM->begin; yylloc->last_column=PARM->end;

extern int do_input(char *buf, int max);
%}

%option noyywrap

str          \"[^\n"]*\"
symb	     "("|")"|","|";"|"="|"+"|"-"|"*"|"/"|"."|"{"|"}"|":"|"$"|"<"|">"|"%"
ws	     [ \t]+
num	     [0-9]+
id	     [[:alpha:]]([[:alnum:]]|_)*
comm	     "//".*
nl	     "\n"|"\r"
tmpl	     "#"[0-9]+
dbl	     [0-9]*\.?[0-9]+([eE][+-]?[0-9]+)?

%%

{str}	{ NEWPOS; 
	  yylval->str = PARM->pool(yytext + 1, yyleng - 2); 
	  return STR; }

{num}	{ NEWPOS;
	  yylval->integer = atoi(yytext); 
	  return INT; }

{dbl}   { NEWPOS;
	  yylval->dbl = atof(yytext);
	  return DBL; }

{symb}	{ NEWPOS; return yytext[0]; }

"if"    { NEWPOS; return IF;   }
"else"  { NEWPOS; return ELSE; }

"true"	{ NEWPOS;
	  yylval->boolean = true;
	  return BOOL; }
"false"	{ NEWPOS;
	  yylval->boolean = false;
	  return BOOL; }

{id}	{ NEWPOS;
	  yylval->str = PARM->pool(yytext);
	  return ID; }

{tmpl}	{ NEWPOS;
	  yylval->integer = atoi(yytext + 1);
	  return TMPLREF; }

"||"	{ NEWPOS; return OR;    }
"&&"	{ NEWPOS; return AND;   }
"=="	{ NEWPOS; return EQ;    }
"!="	{ NEWPOS; return NEQ;   }
"<="    { NEWPOS; return LEQ;   }
">="    { NEWPOS; return GEQ;   }
"++"    { NEWPOS; return PL_PL; }
"--"    { NEWPOS; return MI_MI; }
"+="    { NEWPOS; return PL_EQ; }
"-="    { NEWPOS; return MI_EQ; }

{nl}	{ PARM->line++; PARM->end = 0; }

{ws}	{ NEWPOS; }

{comm}	{ NEWPOS; }

\"[^"]*	{ throw Parse::Error("Unclosed string", PARM->line, PARM->end, PARM->filename); }

.	{ throw Parse::Error("Unknown character", PARM->line, PARM->end, PARM->filename); }

%%


