/***************************************************************************
                                  types.hpp
                             -------------------
                               Sat Oct 19 2002
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TYPES_H
#define TYPES_H

#include <map>
#include <vector>
#include <string>

class DSource;
class EvFilter;
class XOutput;

typedef std::map<std::string, double> CntMap;
typedef std::map<std::string, std::string> DataMap;
typedef std::vector<std::string> DataVector;
typedef std::map<std::string, DSource*> BufferMap;
typedef std::map<std::string, CntMap> CntConMap;
typedef std::map<std::string, DataMap> VarConMap;
typedef std::map<std::string, EvFilter*> FilterMap;
typedef std::map<std::string, XOutput*> OutputBuffMap;

/**
 * light-weight type carrier
 */
template<class T>
struct Type2type
{
    typedef T type;
};

template<class T>
std::string type_name(Type2type<T>) {
     return "unknown type";
}

template<> std::string type_name(Type2type<bool>);
template<> std::string type_name(Type2type<std::string>);
template<> std::string type_name(Type2type<double>);
template<> std::string type_name(Type2type<std::string &>);
template<> std::string type_name(Type2type<double &>);

#endif // TYPES_H
