/***************************************************************************
                                  xmlconf.hpp
                             -------------------
                               Mon Oct 2 2002
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef XMLCONF_H
#define XMLCONF_H

#include <xercesc/dom/DOMNodeFilter.hpp>
#include <xercesc/sax/HandlerBase.hpp>
#include <xercesc/util/XMLString.hpp>

#include "parser/parse.hpp"
#include "mydomparser.hpp"
#include "types.hpp"

XERCES_CPP_NAMESPACE_USE

/**
 * A DOM node filter 
 */
class DOMEvalCfgFilter : public DOMNodeFilter {
public:
     DOMEvalCfgFilter();
     ~DOMEvalCfgFilter();

     /* Inherited from DOMNodeFilter */
     virtual short acceptNode(const DOMNode*) const;
private:
     // unimplemented copy construtor and assignment operator
     DOMEvalCfgFilter(const DOMEvalCfgFilter&);
     DOMEvalCfgFilter & operator = (const DOMEvalCfgFilter&);
};

/**
 * A DOM parser error handler 
 */
class EvalHandlerBase : public HandlerBase {
public:
     EvalHandlerBase();  
     virtual void error(const SAXParseException &exception);
     /* Called by the parser when a error occurs. Inherited from HandlerBase */
     virtual void warning (const SAXParseException &exception);
     /* Called by the parser when a warning occurs. Inherited from HandlerBase */
     ~EvalHandlerBase();  
};


class Databank;
class Varprocessor;

/**
 * Module that interprets the configuration file 
 */
class Configurator {
public:
     Configurator(Databank *databank, Varprocessor *varprc);
     
     /* Inspects a data from the configuration file to a processXXX function */
     void interpretEntry(const DataMap &tagMap, const DOMNode* domnode);
     
     ~Configurator();
     
     /* This structure remembers the row and column number of where
	the different sections of the configuration file start. */
     NodePos nodepos;
private:
     void processFuncSection(const DataMap &tagMap, const DOMNode* domnode);
     void processFunctions(NodeInfo::Node *opers, const unsigned int funtype) const; 
     void processLibfileSection(const DataMap &tagMap); 
     void processTemplate(const std::string &tmplName, NodeInfo::Node* node, const unsigned int args) const;
     
     /* Starts a reader for a file in the <libfile> section */
     void ReadIncludedFile(const std::string &fileName);

     
     Databank *databank_;
     Varprocessor *varprc_;     
     NodeInfo::Node *globalnode;
};


/**
 * Walks the DOM-tree of a XML-file
 */
class CfgFileReader {
public:
     CfgFileReader(const std::string &xmlFile, Configurator *prgConfig);
     
     /* Tranverse the DOM tree and sends relevant nodes to the configurator */
     void walk() const;
     
     ~CfgFileReader();
private:
   /* Check if the node has a child that is a text node */
     bool hasTextNode(const DOMNode *node) const;
  
     /* Pointer to the configurator, used for callback */
     Configurator *prgConfig_;

     /* Pointer to a DOM error handler */
     ErrorHandler *errHandler_;

     /* Pointer to a DOM parser */
     XercesDOMParser *parser_;
};

#endif
