/* message.hh
 * author: Johan Carlberger
 * last change: 2000-03-28
 * comments:
 */

/******************************************************************************

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

******************************************************************************/

#ifndef _message_hh
#define _message_hh

#include <iosfwd>

enum MessageType {
  MSG_ERROR,
  MSG_WARNING,
  MSG_MINOR_WARNING,
  MSG_STATUS,
  MSG_VERBOSE,
  MSG_CONTINUE,
  MSG_COUNTS,
  MSG_N_TYPES
};

#ifdef MESSAGES

extern std::ostream *m_out[MSG_N_TYPES];
inline void SetMessageStream(MessageType t, std::ostream *out) { m_out[t] = out; }
void Message(MessageType t, const char *m1=0, const char *m2=0,
	     const char *m3=0, const char *m4=0);

#else

#define SetMessageStream(t, out)
void Message(MessageType t, const char *m1=0, const char *m2=0,
	     const char *m3=0, const char *m4=0);

#endif
#endif
