// timer.cpp - Johnny Bigert 2001-04-20
/******************************************************************************

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

******************************************************************************/

#if defined(TIMER) && defined(WIN32)

#include "windows.h"
#include "timer.h"

Timer::type Timer::counter() const
{
    LARGE_INTEGER t;
    QueryPerformanceCounter(&t);
    return t.QuadPart; 
}

// jb: my 866 MHz proc returns 864e6.
Timer::type Timer::clocks_per_sec()
{
    LARGE_INTEGER t;
    QueryPerformanceFrequency(&t);
    return t.QuadPart; 
}

#endif // defined(PC_TIMER)
