/* takes as input a wtl file and produces endings and tags for content tags only
 * baseform is set to '.'
 * m = least suffix length, n = max suffix length
 */

/******************************************************************************

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

******************************************************************************/

#include "basics.h"
#include "ensure.h"
#include "letter.h"
#include "morf.h"
#include "taglexicon.h"

#include <fstream>
#include <iostream>

int freqstatmorf(uint m, uint n) {
  TagLexicon tags;
  tags.LoadSlow("tags");
  ensure(tags.IsLoaded());
  char word[100];
  Tag tag;
  while (std::cin.getline(word, MAX_WORD_LENGTH, '\t') && std::cin >> tag.string) {
    uint len = strlen(word);
    ensure (len >= 1);
    Tag *t = tags.Find(tag);
    if (!t) {
      std::cerr << tag << " is an unknown tag: " << std::endl;
      ensure(0);
    }
    if (t->IsContent())
      if (MIN_PREFIX_LENGTH <= len)
	for (uint i=m; i<=n && i<(len-MIN_PREFIX_LENGTH+1); i++) {
	  ensure(word[len-i] != '\0');
	  std::cout << (word + len - i) << tab << t << std::endl;
	}
  }
  return 0;
}

int main() {
  return freqstatmorf(MIN_LAST_CHARS, MAX_LAST_CHARS);
}

