/* wt2ttt.l
 * Input: .wt file (One word-tag pair per row)
 * Output: a .ttt  (One tag-trigram per row)
 * last change: 980216
 */

/******************************************************************************

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

******************************************************************************/

%{
  char tag1[100] = "sen.non";
  char tag2[100] = "sen.non";
  char *t1 = tag1;
  char *t2 = tag2;
  char *tmp;
%}

%x TAG

%%

\t                  { BEGIN(TAG); }
<TAG>.*             { fprintf(yyout, "%s\t%s\t%s\n", t1, t2, yytext); 
                      tmp = t1;
                      t1 = t2;
                      t2 = tmp;
                      strcpy(t2, yytext); }

<TAG>\n             { BEGIN(INITIAL); }
.                   ;

%%


