/* letter.cc
 * author: Johan Carlberger
 * last change: 991215
 * comments:
 */

/******************************************************************************

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

******************************************************************************/

#include "letter.h"

void SpaceFix(char *s) {
  char *t;
  for (t = s; *s;)
    if (*s != '\n') {
      if (IsSpace(*s)) {
	*t++ = ' ';
	while(IsSpace(*++s));
      } else
	*t++ = *s++;
    } else
      s++;
  *t = '\0';
}

void PunctFix(char *s) {
  char *t;
  for (t = s; *s;)
    if (IsPunct(*s))
      s++;
    else *t++ = *s++;
  *t = '\0';
}

void Space2Punct(char *s) {
  char *t;
  for (t = s; *s; s++, t++)
    if (IsSpace(*s) || *s == '.') {
      *t = '.';
      while(IsSpace(*(s+1)) || IsPunct(*(s+1)))
	s++;
    } else
      *t = *s;
  if (*(t-1) != '.')
    *t++ = '.';
  *t = '\0';
}

const uchar lowers[256] = {
   0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
  
  64, 97, 98, 99, 100,101,102,103,104,105,106,107,108,109,110,111,
  112,113,114,115,116,117,118,119,120,121,122, 91, 92, 93, 94, 95,
  96, 97, 98, 99, 100,101,102,103,104,105,106,107,108,109,110,111,
  112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
  
  128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
  144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
  160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
  176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
  
  192,193,194,195,228,229,198,199,200,233,202,203,204,205,206,207,
  208,209,210,211,212,213,246,215,216,217,218,219,220,221,222,223,
  224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
  240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255
};

const uchar uppers[256] = {  
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
  
  64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
  80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
  96, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
  80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90,123,124,125,126,127,
  
  128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
  144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
  160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
  176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
  
  192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
  208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
  224,225,226,227,196,197,230,231,232,201,234,235,236,237,238,239,
  240,241,242,243,244,245,214,247,248,249,250,251,252,253,254,255
};

const char letters[256] = {
  0,0,0,0,0,0,0,0,0,S,S,S,S,S,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  S,E,P,P,P,P,P,P,P,P,P,P,P,P,E,P,
  D,D,D,D,D,D,D,D,D,D,P,P,P,P,P,E,
   
  P,V,C,C,C,V,C,C,C,V,C,C,C,C,C,V, 
  C,C,C,C,C,V,C,C,C,V,C,P,P,P,P,P,
  P,V,C,C,C,V,C,C,C,V,C,C,C,C,C,V, 
  C,C,C,C,C,V,C,C,C,V,C,P,P,P,P,P,
 
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, 
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 
  0,0,0,0,V,V,0,0,0,V,0,0,0,0,0,0,
  0,0,0,0,0,0,V,0,0,0,0,0,0,0,0,0,
  0,0,0,0,V,V,0,0,0,V,0,0,0,0,0,0,
  0,0,0,0,0,0,V,0,0,0,0,0,0,0,0,0
};      

const char rowPos[256] = {
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, 
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   
  0,3,4,4,3,2,3,3,3,2,3,3,3,4,4,2, 
  2,2,2,3,2,2,4,2,4,2,4,0,0,0,0,0,
  0,3,4,4,3,2,3,3,3,2,3,3,3,4,4,2, 
  2,2,2,3,2,2,4,2,4,2,4,0,0,0,0,0,
 
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, 
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,

  0,0,0,0,3,2,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0, 
  0,0,0,0,3,2,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0
}; 

const char colPos[256] = {
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, 
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   
  0,1,5,3,3,3,4,5,6,8,7,8,9,7,6,9, 
  10,1,4,2,5,7,4,2,2,6,1,0,0,0,0,0,
  0,1,5,3,3,3,4,5,6,8,7,8,9,7,6,9, 
  10,1,4,2,5,7,4,2,2,6,1,0,0,0,0,0,
 
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, 
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,

  0,0,0,0,11,11,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0, 
  0,0,0,0,11,11,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0
};

static const int EXTRA_PENALTY = 5;
static const int SWAP_PENALTY = 2;
static const int DOUBLE_PENALTY = 3;
static const int WRONG_PENALTY = 4;

static int d[100][100];

int KeyboardDistance(char a, char b) {
  int r = rowPos[(uchar)a] - rowPos[(uchar)b];
  int c = colPos[(uchar)a] - colPos[(uchar)b];
  int dist = Abs(r) + Abs(c);
  if (dist == 0 && a != b)
    return 10;
  return dist;
}

void InitEditDistance() {
  d[0][0] = 1;
  int i;
  for (i=1; i<100; i++)
    d[0][i] = d[0][i-1] * EXTRA_PENALTY;
  for (i=1; i<100; i++)
    d[i][0] = d[i-1][0] * EXTRA_PENALTY;
}

int EditDistance(const char *string1, const char *string2) {
  char s1[100] = "";
  char s2[100] = "";
  int len1;
  for (len1 = 0; (s1[1+len1] = string1[len1]) != '\0'; len1++);
  int len2;
  for (len2 = 0; (s2[1+len2] = string2[len2]) != '\0'; len2++);
  for (int i=2; i<=len1+len2; i++)
    for (int a=MaxOf(1, i-len2), b=i-a ; a<=MinOf(len1, i) && b>=1; a++, b--) {
      if (s1[a] == s2[b]) {
	d[a][b] = d[a-1][b-1];
	if (s1[a-1] == s1[a] && s1[a-1] != s2[b-1])
	  d[a][b] = d[a-2][b-1] * DOUBLE_PENALTY;
	else if (s2[b-1] == s2[b] && s2[b-1] != s1[a-1])
	  d[a][b] = d[a-1][b-2] * DOUBLE_PENALTY;
      } else {
	d[a][b] = d[a-1][b-1] * KeyboardDistance(s1[a], s2[b]) * WRONG_PENALTY;
	if (s1[a-1] == s2[b] && s1[a] == s2[b-1]) {
	  int d2 = d[a-2][b-2] * SWAP_PENALTY;
	  if (d2 < d[a][b])
	    d[a][b] = d2;
	}
      }
      int d2 = d[a-1][b] * EXTRA_PENALTY;
      if (d2 < d[a][b])
	d[a][b] = d2;
      d2 =  d[a][b-1] * EXTRA_PENALTY;
      if (d2 < d[a][b])
	d[a][b] = d2;
    }
  return d[len1][len2];
}

const char *Str2html(const char *s) { // ugly stuff
  static char string[1000];
  char *t = string;
  for (; *s; s++)
    switch(*s) {
    case '<' : strcpy(t, "&lt;"); t += 4; break;
    case '>' : strcpy(t, "&gt;"); t += 4; break;
    case '&' : strcpy(t, "&amp;"); t += 5; break;
    case '"' : strcpy(t, "&quot;"); t += 6; break;
    case '\n': break;
      //"&nbsp;"            fprintf(yyout, " ");
      //"&eacute;"          fprintf(yyout, "");
    default : *t++ = *s;
    }
  *t = '\0';
  return string;
}


