/* tokenizer.hh
 * author: Johan Carlberger
 * last change: 2000-04-18
 * comments: Tokenizer class:
 */

/******************************************************************************

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

******************************************************************************/

#ifndef _tokenizer_hh
#define _tokenizer_hh

#include <fstream>
#include <string.h>
#include <ctype.h>

#undef yyFlexLexer
#define yyFlexLexer tokenizerFlexLexer
#include "FlexLexer.h"

#include "basics.h"
#include "message.h"
#include "token.h"
#include <sstream>
//inline void tokenizerFlexLexer::LexerError(const char *msg) {
//  std::cout << msg;
//}

class Tokenizer : public tokenizerFlexLexer {
public:
    Tokenizer();
  void SetStream(std::istream *instream) { switch_streams(instream, NULL); } 
  Token Parse() { return (Token) yylex(); }
  int TokenLength() { return YYLeng(); }
  const char* TokenString() { return YYText(); }
  void ParseText();
  int CheckTokens() const;
};

inline Tokenizer::Tokenizer() {
  //  if (xWarnAll && !CheckTokens())
  //    Message(MSG_ERROR, "tokens don't work properly");
}

inline void Tokenizer::ParseText() {
  Token token;
  while ((token = Parse()) != TOKEN_END) {
    if (token != TOKEN_SPACE) {
        if (token != TOKEN_NEWLINE && token != TOKEN_BEGIN_PARAGRAPH) {
            std::cout << TokenString();
        }
        std::cout << tab << token << std::endl;
    }
  }
}

inline int Tokenizer::CheckTokens() const {
  for (int i=0; i<N_TOKENS; i++) {
    Token t = (Token)i;
    if (String2Token(Token2String(t)) != t) {
      std::cout << "CheckTokens(): Token[" << i << "] = " << t << "doesn't work" << std::endl;
      return 0;
    }
  }
  return 1;
}

#endif




