/* inflector.cc
 * author: Johan Carlberger
 * last change: 990921
 * comments: Inflector class
 */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "inflector.h"
#include "file.h"

Inflector::Inflector(const char *lexiconDir) {
  char dir[MAX_FILE_NAME_LENGTH];
  tags.LoadFast(AddFileName(dir, lexiconDir, "tags"));
  words.LoadFast(AddFileName(dir, lexiconDir, "words"), &tags, &newWords);
  Message(MSG_COUNTS, "during loading");
}

void Inflector::GenerateForms(const char *s, const char *newline) {
  words.AnalyzeWordAndPrintInflections(s, newline);
};

const char *Inflector::GetInflectionList(const char *s) {
  static char result[1000];
  words.GetInflectionList(s, result);
  return result;
}

void Inflector::Interact() {
  words.TestInflections();
  Message(MSG_COUNTS, "during generation of forms");
};
