/* Rttstavningsprogram. Version 2.55  2001-10-29
   Copyright (C) 1990-2001
   Joachim Hollman och Viggo Kann
   joachim@nada.kth.se viggo@nada.kth.se
*/

#define HUGEVAR
#ifdef __GNUC__
#define INLINE inline
#define VOLATILE volatile
#else
#define INLINE
#define VOLATILE
#endif

#define PROGRAMNAME    "stava"
#ifndef LIBPATH
/* LIBPATH ska innehlla bibliotekskatalogen med avslutande / 
   (eller avslutande \\ p PC) */
#define LIBPATH "/misc/tcs/language/lib/"
#endif
#define ENVIRONMENTVARIABLE "STAVA"
#define LIBPATHVARIABLE     "STAVALIB" /* environment variable containing lib path */

/* Datafilsnamn om inget annat anges */
#define ELFILENAME        "ELlist"
#define KELFILENAME       "kELlist"
#define FLFILENAME        "FLlist"
#define KFLFILENAME       "kFLlist"
#define ILFILENAME        "ILlist"
#define KILFILENAME       "kILlist"
#define ULFILENAME        "ULlist"
#define KULFILENAME       "kULlist"
#define XLFILENAME	  "XLlist"
#define SLFILENAME        "SLlist"
#define XFORKORTNINGAR    "forkortningar"
#define XNAMN             "namn"
#define XDATATERMEREL     "datatermer.E"
#define XDATATERMERFL     "datatermer.F"
#define XDATATERMERIL     "datatermer.I"
#define XTEX              "tex"
#define XFYRGRAFER        "fyrgraf"
#define DOKUMENTORDLISTEEFTERNAMN ".ord"
#define DOKUMENTELEFTERNAMN       ".ord.E"
#define DOKUMENTFLEFTERNAMN       ".ord.F"
#define DOKUMENTILEFTERNAMN       ".ord.I"
#define DOKUMENTULEFTERNAMN       ".ord.U"
#define ELBITS 22            /* Antal bitar hashfunktionen fr EL ska skapa */
#define FLBITS 22            /* Antal bitar hashfunktionen fr FL ska skapa */
#define ILBITS 19            /* Antal bitar hashfunktionen fr IL ska skapa */
#define ULBITS 19            /* Antal bitar hashfunktionen fr UL ska skapa */
#define XLBITS 22            /* Antal bitar hashfunktionen fr XL ska skapa */
#define ELSIZE (1L<<(ELBITS-3))        /* Antal 8-bitselement i EL-bitvektorn */
#define FLSIZE (1L<<(FLBITS-3))        /* Antal 8-bitselement i FL-bitvektorn */
#define ILSIZE (1L<<(ILBITS-3))        /* Antal 8-bitselement i IL-bitvektorn */
#define ULSIZE (1L<<(ULBITS-3))        /* Antal 8-bitselement i UL-bitvektorn */
#define XLSIZE (1L<<(XLBITS-3))        /* Antal 8-bitselement i XL-bitvektorn */
#define HASHINITVAL 0x4711   /* Startvrde i hashningen */
#define NOOFGRAMS 32         /* Antal bokstver i fyrgramsalfabetet */
#define DELIMGRAM 31         /* Nr som anvnds fr ordbrjan/slut och skiljetecken i fyrgram */
#define DELIMP 1             /* Nr som anvnds fr ordbrjan/slut och skiljetecken i p-tabeller */
#define FGRAMSIZE 131072L    /* Antal 8-bitselement i fyrgramsbitvektorn */
#define LANGD 50             /* Lngsta tilltna ord */
#define FILENAMELENGTH 100   /* Lngsta tilltna filnamn+1 */
#define DELORDMIN 3          /* Minsta tillta ordlngd i sammansttningar */
#define SLUTDELORDMIN 3      /* Minsta tillta ordlngd p sista ordet i sammansttningar */
#define DELORDMAX 22         /* Lngsta tilltna delord */
#define MAXORDDELAR 4        /* hgsta antal delar i ett sammansatt ord */
#define PREFIXMIN 2          /* Minsta tillta ordlngd fre suffix */
#define MAXSUFFIXMEMSIZE 12  /* Minnesstorlek fr snabbminnet i suffix.c */
#define ORDMIN 2             /* Ord som r kortare n ORDMIN hoppas ver */
#define VSHIFT 7             /* Hur mycket nsta pow2 r vnstershiftad */
#define FLNOOFHASH 7         /* Antal hashningar i FL */
#define ELNOOFHASH 7         /* Antal hashningar i EL */
#define ILNOOFHASH 4         /* Antal hashningar i IL */
#define ULNOOFHASH 4         /* Antal hashningar i UL */
#define XLNOOFHASH 6         /* Antal hashningar i XL */

#define ISOCODE 1            /* vrde p variabeln x8bitar fr ISO 8859-1 */
#define MACCODE 2            /* vrde p variabeln x8bitar fr Mackodning */
#define DOSCODE 3            /* vrde p variabeln x8bitar fr Doskodning */

extern char isLowerCase[256]; /* r x en liten bokstav? */
extern char isUpperCase[256]; /* r x en stor bokstav? */
extern char isVowel[256]; /* r x en versal? */
extern char isDelim[256]; /* r x en icke-bokstav? */
extern unsigned char toLowerCase[256]; /* omvandla stor till liten bokstav */
extern unsigned char toUpperCase[256]; /* omvandla stor till liten bokstav */
extern unsigned char *lowerCaseLetters; /* alla sm bokstver */
extern unsigned char *upperCaseLetters; /* alla stora bokstver */
extern unsigned char *delimiters; /* alla icke-bokstver */

extern INLINE void VersalerGemena(register const unsigned char *ordin, 
				  register unsigned char *ord,
				  register unsigned char *Ord);
/* StavaSkrivOrd anropas vid rttstavningen fr att skriva ut ett
   rttstavningsfrslag. */
extern void StavaSkrivOrd(const unsigned char *s);

/* StavaSkrivSeparator anropas vid rttstavningen fr att skriva ut 
   wordSeparator mellan tv rttstavningsfrslag. */
void StavaSkrivSeparator(void);

/* WriteISO skriver ut en ASCII-textstrng versatt till ISO Latin-1 */
extern void WriteISO(const unsigned char *s);

/* sWriteISO skriver ut en ASCII-textstrng versatt till ISO Latin-1 p strng */
extern void sWriteISO(unsigned char *res, const unsigned char *s);

extern INLINE int InEL(const unsigned char *ord, int len);
extern INLINE int InFL(const unsigned char *ord, int len);
extern INLINE int InIL(const unsigned char *ord, int len);
extern INLINE int InUL(const unsigned char *ord, int len);
extern INLINE int InXL(const unsigned char *ord, int len);
extern INLINE int InILorELbutnotUL(const unsigned char *ord, int len);

extern int x8bitar;
extern int xAndelser, xForkortningar, xNamn, xDatatermer;
extern int xTex;
extern int xSammansatta, xKort;
extern int xDebug;
extern int xTillatSIFogar, xTillatSIAllaFogar;
extern int xGenereraSammansatta, xIntePetig;
extern int xHtml, xEndastEtt, xRattstavningsforslag, xMaxOneError;
extern int xAcceptCapitalWords;

/* Definieras i stavaconstants.h: */
extern unsigned char ISO_intern[256];
extern unsigned char MAC_intern[256];
extern unsigned char DOS_intern[256];
extern unsigned char intern_ISO[256];
extern unsigned char MAC_ISO[256];
extern unsigned char DOS_ISO[256];
extern unsigned char ISO_ISO[256];
extern unsigned char ASCII_intern[256];
extern unsigned char intern_gram[256];
extern unsigned char intern_p[256];
extern unsigned char dubbelBokstavsTabell[256];
extern unsigned char transform_diacritics[256];
extern unsigned char bindebokstav[];
extern unsigned char isConsonant[256];
