#include "split_compounds.h"

#include <cstdlib>
#include <cstring>
#include <iostream>
#include <sstream>
#include <vector>
#include <string>

/* Location of data files for Stava*/
#define LIBPATH "../GPLstava_extra/lib/"

#include <unistd.h>
#include <signal.h>
#include <errno.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <netinet/in.h>
#include <netdb.h>
#include <strings.h>

int REQUESTS = 0;
int WORDS = 0;
int COMPOUNDS = 0;

void read_data(int socket, std::vector<std::string> &words) {
  char buf[10000+1];
  buf[0] = 0;
  bool done = 0;
  std::string text = "";

  while(!done) {
    int len = 0, offs = 0;
    while(offs < 10000 && !done) {
      len = read(socket, buf+offs, 10000 - offs);
      if(len > 0) {
	buf[10000] = 0;
	char *end = strstr(buf, "ENDQ");
	if(end) {
	  *end = 0;
	  done = 1;
	} else {
	  offs += len;
	}
      } else {
	buf[offs] = 0;
	done = 1;
      }
    }
    text += buf;
    int tl = text.length() - 10;
    if(tl < 0)
      tl = 0;
    if(text.substr(tl).find("ENDQ") != std::string::npos) {
      done = 1;
    }
  }
  std::istringstream is(text);
  while(is) {
    std::string word;
    is >> word;
    if(word == "ENDQ") {
      break;
    }
    if(word.length() > 0) {
      words.push_back(word);
    }
  }
}

// taken from a socket primer
int establish(int portnum)
{ 
  const int MAXHOSTNAME = 1000;
  char myname[MAXHOSTNAME+1];
  int s;
  struct sockaddr_in sa;
  struct hostent *hp;
  
  bzero(&sa,sizeof(struct sockaddr_in));
  gethostname(myname,MAXHOSTNAME);
  hp= gethostbyname(myname);
  if (hp == NULL)
    return -1;
  sa.sin_family= hp->h_addrtype; /* this is our host address */
  sa.sin_port= htons(portnum); /* this is our port number */
  if ((s = socket(AF_INET,SOCK_STREAM,0)) < 0)
    return -1;
  if (bind(s,(struct sockaddr *)&sa,sizeof(sa)) < 0) {
    close(s);
    return -1;
  }
  listen(s, 5); /* max # of queued connects */
  return s;
}

// taken from a socket primer
int get_connection(int s // socket
		   )
{ 
  struct sockaddr_in isa;
  socklen_t i;
  int t;
  
  i = sizeof(isa);
  getsockname(s,(struct sockaddr *)&isa,&i);
  
  if ((t = accept(s,(struct sockaddr *)&isa,&i)) < 0)   /* accept connection if there is one */
    return -1;
  return t;
}

int main(int argc, char **argv) {
  
  if(argc != 7) {
    std::cerr << argv[0] << " <head freqs> <tail freqs> <ngram-stats> <port no> <tagger lexicon> <tag tag stats>\n";
    return 0;
  }

  /* handler for child processes */
  signal(SIGCHLD, SIG_IGN);

  int portno = atoi(argv[4]);
  int server_socket;
  if ((server_socket = establish(portno)) < 0) {  /* plug in the phone */
    std::cerr << "could not open socket for listening\n";
    exit(1);
  }

  init(LIBPATH, argv[1], argv[2], argv[3], argv[5], argv[6]);

  std::vector<std::string> words, result;
  
  while(1) {
    std::cerr << "waiting...\n";
    int client_socket = 0;
    if ((client_socket = get_connection(server_socket)) < 0) {
      if (errno == EINTR)
	continue;
      std::cerr << "error on accept\n";
      exit(1);
    }
    
    // fork all client calls, that way, if they hang or crash,
    // the server keeps working
    std::ostringstream buf;
    switch(fork()) {
    case -1 : // error
      std::cerr << "error on fork()\n";
      exit(1);
    case 0 : // child
      close(server_socket);
      words.clear();
      alarm(60*2); // if we still haven't finished in 2 minutes, die...

      read_data(client_socket, words);
      alarm(0); // remove alarm
      
      result.clear();
      split_compounds(words, result);
      
      buf << "<reply>\n";
      for(int i = 0; i < words.size(); i++) {
	buf << words[i];
	if(result[i] != "") {
	  buf << "\t" << result[i];
	  COMPOUNDS++;
	}
	WORDS++;
	buf << "\n";
      }
      buf << "</reply>\n";

      write(client_socket, buf.str().c_str(), buf.str().length() * sizeof(char));
      
      close(client_socket);
      exit(0); // child is finished
    default : // parent
      REQUESTS++;
      close(client_socket);
    }
  }
  return 0;
}
