/* Rttstavningsprogram. Version 2.66  2016-07-24
   Copyright (C) 1990-2016
   Joachim Hollman och Viggo Kann
   joachim@algoritmica.se viggo@nada.kth.se
*/

/******************************************************************************

    This file is part of Stava.

    Stava is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Stava is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Stava.  If not, see <http://www.gnu.org/licenses/>.

******************************************************************************/

#define VERSION "Stava version 2.66"
/* #define DEBUG testversion med debugmjligheter (vljaren -D) */
/* #define MORFANALYS */ /* Morfologianalys med sammansttningsanalys */
/* #define STATISTIK */ /* Skriv ut hashningsstatistik */
/* #define TAGGSTAVA */ /* Ordklasstagga orden (inte trdsker!) */
/* #define KOLLASAMMANSATT */ /* Ge statistik fr (tvleds)sammansttningar */

#ifdef TAGGSTAVA
#define TRYALLRULES /* alla regler ska testas */
#else
#ifndef GENERERA
#define RATTSTAVA /* Vljaren -r som ger rttstavningsfrslag kan anvndas */
#endif
#endif
#ifdef TRYALLRULES
#ifndef MORFANALYS
#define MORFANALYS /* gBreaks mm behvs i TRYALLRULES */
#endif
#endif
#ifdef GENERERA
#ifdef MORFANALYS
#undef MORFANALYS
#endif
extern int GenereraFormer(unsigned char *line);
extern int xGrundform; /* Skriv ut ordets grundform om xGrundform == 1 */
#endif
#ifdef MORFANALYS
#define CHOOSEBESTCOMPOUNDING
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <locale.h>

#ifdef WWWSTAVA
#define wwwstatic
#else
#define wwwstatic static
#endif

#include "stava.h"
#ifdef RATTSTAVA
#include "rattstava.h"
#endif
#include "suffix.h"

#ifdef API
#include "libstava.h"
#else
#define SCANNER
#endif
#include "stavaconstants.h"

#ifdef KOLLASAMMANSATT
#undef SLUTDELORDMIN
#define SLUTDELORDMIN 2  /* Minsta tillta ordlngd p sista ordet i sammansttningar */
#ifndef API
static long antalFel = 0, antalOsammansatta = 0, antalRiktiga = 0;
#endif
#endif
#ifdef CHOOSEBESTCOMPOUNDING
static float compfactor = 3.0; /* Skalfaktor vid sammansttningsanalys */
#endif

static const char *libpath; /* path to library directory, should end with / */
static unsigned char HUGEVAR ELtable[ELSIZE];
static unsigned char HUGEVAR FLtable[FLSIZE];
static unsigned char HUGEVAR ILtable[ILSIZE];
static unsigned char HUGEVAR ULtable[ULSIZE];
#ifdef RATTSTAVA
static unsigned char HUGEVAR XLtable[XLSIZE];
static char XLfilename[FILENAMELENGTH];
static char fyrgramfilename[FILENAMELENGTH];
#endif
static char ELfilename[FILENAMELENGTH];
static char FLfilename[FILENAMELENGTH];
static char ILfilename[FILENAMELENGTH];
static char ULfilename[FILENAMELENGTH];
static char SLfilename[FILENAMELENGTH];
char isLowerCase[256]; /* r x en liten bokstav? */
char isUpperCase[256]; /* r x en stor bokstav? */
char isVowel[256]; /* r x en versal? */
char isDelim[256]; /* r x en icke-bokstav? */
unsigned char toLowerCase[256]; /* omvandla stor till liten bokstav */
unsigned char toUpperCase[256]; /* omvandla stor till liten bokstav */
unsigned char *lowerCaseLetters; /* alla sm bokstver */
unsigned char *upperCaseLetters; /* alla stora bokstver */
unsigned char *delimiters; /* alla icke-bokstver */
int xHtml = 0;
#ifdef WWWSTAVA
int xEndastEtt = 0;
unsigned char **infiler = NULL;   /* vektor med pekare till infilnamn */
int antalInfiler = 0;    /* sista anvnda texten i infiler */
#else
#ifdef SCANNER
static FILE *ordf;
#endif
#ifndef API
int xEndastEtt = 0, xInvertera = 0;
static char **infiler = NULL;   /* vektor med pekare till infilnamn */
static int antalInfiler = 0;    /* sista anvnda texten i infiler */
static char utELfilename[FILENAMELENGTH], utFLfilename[FILENAMELENGTH];
static char utILfilename[FILENAMELENGTH], utULfilename[FILENAMELENGTH];
static char utSLfilename[FILENAMELENGTH];
static char ordfNamn[FILENAMELENGTH];
static int filter = 0;
static int xLasOrdlista = 1, xInforOrdlista = 0;
static int xSkrivLexikon = 0;
static int laserOrdlista = 0, inforOrdlista = 0;
static int fleraInfiler = 0;    /* sant om antalInfiler > 1 */
static int aktuelltFilnr = 0;   /* vilken av filerna som stavningskollas fn */
static char **ordlistor = NULL; /* vektor med pekare till ordlistenamn */
static char *ordlisttyp = NULL; /* vektor med pekare till ordlistenamnstyper */
static int antalOrdlistor = 0;  /* sista anvnda texten i ordlistor */
static unsigned char **enstakaOrd = NULL;/* vektor med pekare till enstaka ord
                                   som ska kollas av Stava */
static int antalEnstakaOrd = 0; /* antal angivna enstaka ord (med -w) */
#endif /* not API */
#endif /* not WWWSTAVA */
static FILE *ELfp, *FLfp, *ILfp, *ULfp, *xELfp;
int xAndelser = 1, xForkortningar = 0, xNamn = 0, xDatatermer = 0;
int xTex = 0;
int xSammansatta = 1, xKort = 0;
int xTillatSIFogar = 1; /* Tillt s i vissa fogar, t ex FL FL s EL */
int xTillatSIAllaFogar = 0; /* Tillt t ex FL s FL EL */
int xAcceptCapitalWords = 1; /* Tillt ord med bara versaler */
int xxDebug = 0;
#ifdef TRYALLRULES
int xCollectWordsInOutput = 1; /* Samla ihop alla taggar/lemman fr varje ord */
int xLemmatize = 0; /* returnera ven lemmaform */
#endif
int xPrintError = 1; /* Skriv ut felmeddelanden p stderr */
char stavaerrorbuf[400]; /* buffer for last error message */

#ifdef CHOOSEBESTCOMPOUNDING
#define MAXNOOFCOMPOUNDS 20

/* Data som anvnds fr sammansttningsanalys */
struct compoundData {
  char breakpossibilities[MAXNOOFCOMPOUNDS][LANGD];
  int breakposparts[MAXNOOFCOMPOUNDS];
  float breakposlen[MAXNOOFCOMPOUNDS];
  int noofcompounds;
  char gBreaks[LANGD + 3];
  unsigned char *wordprefix;
};

#endif
#ifdef DEBUG
static int xWriteSuffix = 0;
#endif
#ifdef RATTSTAVA
int xIntePetig = 1;
int xRattstavningsforslag = 0, xGenerateCompounds = 1, xMaxOneError = 1;
#endif

int utf8locale = 0; /* Anger om anvndarens locale innehller utf-8 och ger d utmatning i utf-8 */
static int angettTeckenkod = 0; /* Talar om ifall teckenkod explicit angetts */
#ifndef DEFAULTCODE
#define DEFAULTCODE ISOCODE
#endif
int x8bitar = DEFAULTCODE; /* Anger teckenkod (ISOCODE, MACCODE, DOSCODE, UTF8CODE, 0) */
static unsigned char *bokstavsTabell;    /* versttning kod -> intern */
wwwstatic unsigned char *tillISOTabell;     /* versttning kod -> ISO Latin-1 */

static int ungotCharString = 0;

INLINE int utf8GetFromString(unsigned char **s) {
  int nb;
  int ch = 0;
  int src;
  if (ungotCharString) {
    int tmp = ungotCharString;
    ungotCharString = 0;
    return tmp;
  }
  src = *(*s)++;
  nb = trailingBytesForUTF8[src];
  switch (nb) {
    /* these fall through deliberately */
  case 3: ch += src; ch <<= 6; src = *(*s)++;
  case 2: ch += src; ch <<= 6; src = *(*s)++;
  case 1: ch += src; ch <<= 6; src = *(*s)++;
  case 0: ch += src;
  }
  ch -= offsetsFromUTF8[nb];
  if (ch >= 256) return ' '; /* return space for non-standard characters */
  return ch;
}

int utf8string2iso(char *dest, int destSize, unsigned char *src) {
  int i;
  for (i = 0; *src && i < destSize; i++) {
    *dest++ = utf8GetFromString(&src);
  }
  if (i < destSize) *dest = '\0';
  return i;
}

#ifdef WWWSTAVA
#ifdef stderr
#undef stderr
#endif
#define stderr stdout
unsigned char *textp; /* pekare p aktuell plats i texten */
unsigned char *startWord; /* pekare p senaste ordbrjan i texten */
unsigned char *endWord; /* pekare p senaste ordslut i texten */
#define get(f) (x8bitar == UTF8CODE ? utf8GetFromString(&textp) : (unsigned char)(*textp++))
#define unget(c,f) {if (x8bitar == UTF8CODE) ungotCharString = c; else --textp;}
#define ENDOFFILE 0
#else
#ifdef SCANNER
static int ungotChar = 0;

INLINE int utf8get(FILE *f) {
  int nb;
  int ch = 0;
  int src;
  if (ungotChar) {
    int tmp = ungotChar;
    ungotChar = 0;
    return tmp;
  }
  src = getc(f);
  if (src <= 0) return src;
  nb = trailingBytesForUTF8[src];
  switch (nb) {
    /* these fall through deliberately */
  case 3: ch += src; ch <<= 6; src = getc(f);
  case 2: ch += src; ch <<= 6; src = getc(f);
  case 1: ch += src; ch <<= 6; src = getc(f);
  case 0: ch += src;
  }
  ch -= offsetsFromUTF8[nb];
  if (ch >= 256) return ' '; /* return space for non-standard characters */
  return ch;
}

#define get(f) (x8bitar == UTF8CODE ? utf8get(f) : getc(f))
#define unget(c,f) (x8bitar == UTF8CODE ? (ungotChar = c) : ungetc(c,f))
#define ENDOFFILE EOF
#endif
#endif

/* srcsz = number of source characters, or -1 if 0-terminated
   destsize = size of dest buffer in bytes

   returns # characters converted
   dest will only be '\0'-terminated if there is enough space. this is
   for consistency; imagine there are 2 bytes of space left, but the next
   character requires 3 bytes. in this case we could NUL-terminate, but in
   general we can't when there's insufficient space. therefore this function
   only NUL-terminates if all the characters fit, and there's space for
   the NUL as well.
   the destination string will never be bigger than the source string.
*/
int iso2utf8(char *dest, int destsize, const unsigned char *src, int srcsz) 
{ int ch;
  int i = 0;
  char *dest_end = dest + destsize;
    while (srcsz<0 ? src[i]!=0 : i < srcsz) {
        ch = src[i];
        if (ch < 0x80) {
            if (dest >= dest_end)
                return i;
            *dest++ = (char)ch;
        }
        else if (ch < 0x800) {
            if (dest >= dest_end-1)
                return i;
            *dest++ = (ch>>6) | 0xC0;
            *dest++ = (ch & 0x3F) | 0x80;
        }
        else if (ch < 0x10000) {
            if (dest >= dest_end-2)
                return i;
            *dest++ = (ch>>12) | 0xE0;
            *dest++ = ((ch>>6) & 0x3F) | 0x80;
            *dest++ = (ch & 0x3F) | 0x80;
        }
        else if (ch < 0x110000) {
            if (dest >= dest_end-3)
                return i;
            *dest++ = (ch>>18) | 0xF0;
            *dest++ = ((ch>>12) & 0x3F) | 0x80;
            *dest++ = ((ch>>6) & 0x3F) | 0x80;
            *dest++ = (ch & 0x3F) | 0x80;
        }
        i++;
    }
    if (dest < dest_end)
        *dest = '\0';
    return i;
}

/* PrintLocale skriver ut en strng i Latin1 i aktuell locale */
void PrintLocale(FILE *f, const char *s)
{
  if (utf8locale) {
    char buf[1001];
    buf[1000] = '\0';
    iso2utf8(buf, 1000, (unsigned char *) s, -1);
    fprintf(f, "%s", buf);
  } else
    fprintf(f, "%s", s);
}

/* PrintErrorWithText prints an error containing a text argument. format is a 
  formating string containing the string %s */
void PrintErrorWithText(const char *format, const char *text)
{
  if (strlen(format) + strlen(text) >= 300) {
    if (strlen(format) >= 300) sprintf(stavaerrorbuf, "Ett fel har uppsttt.\n");
    else sprintf(stavaerrorbuf, format, "<fr lngt>");
  } else sprintf(stavaerrorbuf, format, text);
  if (xPrintError) PrintLocale(stderr, stavaerrorbuf);
}

/* WriteISO skriver ut en ASCII-textstrng versatt till ISO Latin-1 */
void WriteISO(const unsigned char *s)
{ char buf[1005], *bufp = buf, *bufpend = buf + 1000;
  int ch;
  while (*s && bufp < bufpend) {
    ch = intern_ISO[*s++];
#ifdef WWWSTAVA
    switch (ch) {
    case '<': strcpy(bufp, "&lt;"); bufp += strlen(bufp); break;
    case '>': strcpy(bufp, "&gt;"); bufp += strlen(bufp); break;
    case '&': strcpy(bufp, "&amp;"); bufp += strlen(bufp); break;
    default: *bufp++ = ch;
    }
#else
    *bufp++ = ch;
#endif
  }
  *bufp = '\0';
  PrintLocale(stdout, buf);
}

/* sWriteISO skriver ut en ASCII-textstrng versatt till ISO Latin-1 p strng */
void sWriteISO(unsigned char *res, const unsigned char *s)
{ int ch;
  while (*s) {
    ch = intern_ISO[*s++];
#ifdef WWWSTAVA
    switch (ch) {
    case '<': *res++ = '&'; *res++ = 'l'; *res++ = 't'; *res++ = ';'; break;
    case '>': *res++ = '&'; *res++ = 'g'; *res++ = 't'; *res++ = ';'; break;
    case '&': *res++ = '&'; *res++ = 'a'; *res++ = 'm'; *res++ = 'p'; *res++ = ';'; break;
    default: *res++ = ch;
    }
#else
    *res++ = ch;
#endif
  }
  *res = '\0';
}

#ifdef CHOOSEBESTCOMPOUNDING
#ifdef API
/* StringWriteCompound skriver word med ordbrytningsmarkeringar i res */
/* breaks[0] fr inte vara en ordbrytningsmarkering */
static void StringWriteCompound(unsigned char *res, const unsigned char *word, 
			  char *breaks)
{ 
  while (*word && *breaks) {
    if (*breaks == 's') { *res++ = '|'; *res++ = 's'; *res++ = '|'; }
    else {
      if (*breaks == '|' && word[-1] != '-') *res++ = '|';
      *res++ = intern_ISO[*word];
    }
    if (*breaks == '<') {
      *res++ = '|';
      *res++ = intern_ISO[*word];
    }
    word++;
    breaks++;
  }
  while (*word) {
    *res++ = intern_ISO[*word];
    word++;
  }
  *res = '\0';
}
#endif /* API */

/* WriteCompound skriver ut ett ord med ordbrytningsmarkeringar */
static void WriteCompound(const unsigned char *word, char *breaks)
{ 
  while (*word) {
    if (*breaks == 's') printf("|s|");
    else {
      if (*breaks == '|') putchar('|');
      putchar(intern_ISO[*word]);
    }
    if (*breaks == '<') {
      putchar('|');
      putchar(intern_ISO[*word]);
    }
    word++;
    breaks++;
  }
}
#endif /* CHOOSEBESTCOMPOUNDING */

typedef unsigned int ub4;  /* unsigned 4-byte quantities */

#define hashsize(n) ((ub4)1<<(n))
#define hashmask(n) (hashsize(n)-1)


/*
--------------------------------------------------------------------
mix -- mix 3 32-bit values reversibly.
For every delta with one or two bit set, and the deltas of all three
  high bits or all three low bits, whether the original value of a,b,c
  is almost all zero or is uniformly distributed,
* If mix() is run forward or backward, at least 32 bits in a,b,c
  have at least 1/4 probability of changing.
* If mix() is run forward, every bit of c will change between 1/3 and
  2/3 of the time.  (Well, 22/100 and 78/100 for some 2-bit deltas.)
mix() takes 36 machine instructions, but only 18 cycles on a superscalar
  machine (like a Pentium or a Sparc).  No faster mixer seems to work,
  that's the result of my brute-force search.  There were about 2^^68
  hashes to choose from.  I only tested about a billion of those.
--------------------------------------------------------------------
*/
#define mix(a,b,c) \
{ \
  a -= b; a -= c; a ^= (c>>13); \
  b -= c; b -= a; b ^= (a<<8); \
  c -= a; c -= b; c ^= (b>>13); \
  a -= b; a -= c; a ^= (c>>12);  \
  b -= c; b -= a; b ^= (a<<16); \
  c -= a; c -= b; c ^= (b>>5); \
  a -= b; a -= c; a ^= (c>>3);  \
  b -= c; b -= a; b ^= (a<<10); \
  c -= a; c -= b; c ^= (b>>15); \
}

/*
--------------------------------------------------------------------
hash() -- hash a variable-length key into a 32-bit value
  k     : the key (the unaligned variable-length array of bytes)
  len   : the length of the key, counting by bytes
  level : can be any 4-byte value
Returns a 32-bit value.  Every bit of the key affects every bit of
the return value.  Every 1-bit and 2-bit delta achieves avalanche.
About 36+6len instructions.

The best hash table sizes are powers of 2.  There is no need to do
mod a prime (mod is sooo slow!).  If you need less than 32 bits,
use a bitmask.  For example, if you need only 10 bits, do
  h = (h & hashmask(10));
In which case, the hash table should have hashsize(10) elements.

If you are hashing n strings (ub1 **)k, do it like this:
  for (i=0, h=0; i<n; ++i) h = hash( k[i], len[i], h);

By Bob Jenkins, 1996.  74512.261@compuserve.com.  You may use this
code any way you wish, private, educational, or commercial.  It's free.

See http://ourworld.compuserve.com/homepages/bob_jenkins/evahash.htm
Use for hash table lookup, or anything where one collision in 2^32 is
acceptable.  Do NOT use for cryptographic purposes.
--------------------------------------------------------------------
*/

INLINE int InEL(const unsigned char *k,        /* the key */
		int length)   /* the length of the key */
{  register int len = length;
   register ub4 a,b,c;
   register ub4 h, olda, oldb;
   register int i = 0;

   /* Set up the internal state */
   a = b = 0x9e3779b9;  /* the golden ratio; an arbitrary value */
   c = HASHINITVAL;           /* the previous hash value */

   /*---------------------------------------- handle most of the key */
   while (len >= 12)
   {
      a += (k[0] +((ub4)k[1]<<8) +((ub4)k[2]<<16) +((ub4)k[3]<<24));
      b += (k[4] +((ub4)k[5]<<8) +((ub4)k[6]<<16) +((ub4)k[7]<<24));
      c += (k[8] +((ub4)k[9]<<8) +((ub4)k[10]<<16)+((ub4)k[11]<<24));
      mix(a,b,c);
      k += 12; len -= 12;
   }

   /*------------------------------------- handle the last 11 bytes */
   c += length;
   switch(len)              /* all the case statements fall through */
   {
   case 11: c+=((ub4)k[10]<<24);
   case 10: c+=((ub4)k[9]<<16);
   case 9 : c+=((ub4)k[8]<<8);
      /* the first byte of c is reserved for the length */
   case 8 : b+=((ub4)k[7]<<24);
   case 7 : b+=((ub4)k[6]<<16);
   case 6 : b+=((ub4)k[5]<<8);
   case 5 : b+=k[4];
   case 4 : a+=((ub4)k[3]<<24);
   case 3 : a+=((ub4)k[2]<<16);
   case 2 : a+=((ub4)k[1]<<8);
   case 1 : a+=k[0];
     /* case 0: nothing left to add */
   }
   olda = a; oldb = b;
   mix(a,b,c);
   /*-------------------------------------------- report the result */
   h = c & hashmask(ELBITS);
   if (!(ELtable[h >> 3] & (1 << (int)(h & 7)))) {
      return 0;
   }
   for (i = 1; i < ELNOOFHASH; i++) {
     a = olda; b = oldb;
     mix(a,b,c);
     h = c & hashmask(ELBITS);
     if (!(ELtable[h >> 3] & (1 << (int)(h & 7)))) {
        return 0;
     }
   }
   return 1;
}

/* InILorELbutnotUL kollar om ordet k med lngden length finns i
ordlistorna IL eller EL men inte i UL. I s fall returneras 1.
Om ordet finns i UL returneras -1, annars returneras 0. */
INLINE int InILorELbutnotUL(const unsigned char *k,        /* the key */
		    int length)   /* the length of the key */
{  register int len = length;
   register ub4 a,b,c;
   register ub4 h, olda, oldb;
   ub4 ccache[ELNOOFHASH];
   register int i=0;
   register int j;
   int res = 0;

   /* Set up the internal state */
   a = b = 0x9e3779b9;  /* the golden ratio; an arbitrary value */
   c = HASHINITVAL;           /* the previous hash value */

   /*---------------------------------------- handle most of the key */
   while (len >= 12)
   {
      a += (k[0] +((ub4)k[1]<<8) +((ub4)k[2]<<16) +((ub4)k[3]<<24));
      b += (k[4] +((ub4)k[5]<<8) +((ub4)k[6]<<16) +((ub4)k[7]<<24));
      c += (k[8] +((ub4)k[9]<<8) +((ub4)k[10]<<16)+((ub4)k[11]<<24));
      mix(a,b,c);
      k += 12; len -= 12;
   }

   /*------------------------------------- handle the last 11 bytes */
   c += length;
   switch(len)              /* all the case statements fall through */
   {
   case 11: c+=((ub4)k[10]<<24);
   case 10: c+=((ub4)k[9]<<16);
   case 9 : c+=((ub4)k[8]<<8);
      /* the first byte of c is reserved for the length */
   case 8 : b+=((ub4)k[7]<<24);
   case 7 : b+=((ub4)k[6]<<16);
   case 6 : b+=((ub4)k[5]<<8);
   case 5 : b+=k[4];
   case 4 : a+=((ub4)k[3]<<24);
   case 3 : a+=((ub4)k[2]<<16);
   case 2 : a+=((ub4)k[1]<<8);
   case 1 : a+=k[0];
     /* case 0: nothing left to add */
   }
   olda = a; oldb = b;
   mix(a,b,c);
   /*-------------------------------------------- report the result */
   ccache[0] = c;
   h = c & hashmask(ILBITS);
   if (!(ILtable[h >> 3] & (1 << (int)(h & 7)))) {
      goto checkEL;
   }
   for (i = 1; i < ILNOOFHASH; i++) {
     a = olda; b = oldb;
     mix(a,b,c);
     ccache[i] = c;
     h = c & hashmask(ILBITS);
     if (!(ILtable[h >> 3] & (1 << (int)(h & 7)))) {
        goto checkEL;
     }
   }
   return 1;
 checkEL:
#if (ELNOOFHASH < ILNOOFHASH)
   if (i >= ELNOOFHASH) i = ELNOOFHASH - 1;
#endif
   for (j = 0; j <= i; j++) {
     h = ccache[j] & hashmask(ELBITS);
     if (!(ELtable[h >> 3] & (1 << (int)(h & 7)))) {
       goto checkUL;
     }     
   }
   i++;
   for (; i < ELNOOFHASH; i++) {
     a = olda; b = oldb;
     mix(a,b,c);
     ccache[i] = c;
     h = c & hashmask(ELBITS);
     if (!(ELtable[h >> 3] & (1 << (int)(h & 7)))) goto checkUL;
   }
   res = 1;
 checkUL:
#ifdef VOCABULARYINUL
   return res;
#else
#if (ULNOOFHASH < ELNOOFHASH)
   if (i >= ULNOOFHASH) i = ULNOOFHASH - 1;
#endif
   for (j = 0; j <= i; j++) {
     h = ccache[j] & hashmask(ULBITS);
     if (!(ULtable[h >> 3] & (1 << (int)(h & 7)))) {
       return res;
     }     
   }
   i++;
   for (; i < ULNOOFHASH; i++) {
     a = olda; b = oldb;
     mix(a,b,c);
     h = c & hashmask(ULBITS);
     if (!(ULtable[h >> 3] & (1 << (int)(h & 7)))) return res;
   }
   return -1; /* ordet med i undantagsordlistan */
#endif /* not VOCABULARYINUL */
}

INLINE int InFL(const unsigned char *k,        /* the key */
		int length)   /* the length of the key */
{  register int len = length;
   register ub4 a,b,c;
   register ub4 h, olda, oldb;
   register int i;

   /* Set up the internal state */
   a = b = 0x9e3779b9;  /* the golden ratio; an arbitrary value */
   c = HASHINITVAL;           /* the previous hash value */

   /*---------------------------------------- handle most of the key */
   while (len >= 12)
   {
      a += (k[0] +((ub4)k[1]<<8) +((ub4)k[2]<<16) +((ub4)k[3]<<24));
      b += (k[4] +((ub4)k[5]<<8) +((ub4)k[6]<<16) +((ub4)k[7]<<24));
      c += (k[8] +((ub4)k[9]<<8) +((ub4)k[10]<<16)+((ub4)k[11]<<24));
      mix(a,b,c);
      k += 12; len -= 12;
   }

   /*------------------------------------- handle the last 11 bytes */
   c += length;
   switch(len)              /* all the case statements fall through */
   {
   case 11: c+=((ub4)k[10]<<24);
   case 10: c+=((ub4)k[9]<<16);
   case 9 : c+=((ub4)k[8]<<8);
      /* the first byte of c is reserved for the length */
   case 8 : b+=((ub4)k[7]<<24);
   case 7 : b+=((ub4)k[6]<<16);
   case 6 : b+=((ub4)k[5]<<8);
   case 5 : b+=k[4];
   case 4 : a+=((ub4)k[3]<<24);
   case 3 : a+=((ub4)k[2]<<16);
   case 2 : a+=((ub4)k[1]<<8);
   case 1 : a+=k[0];
     /* case 0: nothing left to add */
   }
   olda = a; oldb = b;
   mix(a,b,c);
   /*-------------------------------------------- report the result */
   h = c & hashmask(FLBITS);
   if (!(FLtable[h >> 3] & (1 << (int)(h & 7)))) {
      return 0;
   }
   for (i = 1; i < FLNOOFHASH; i++) {
     a = olda; b = oldb;
     mix(a,b,c);
     h = c & hashmask(FLBITS);
     if (!(FLtable[h >> 3] & (1 << (int)(h & 7)))) {
        return 0;
     }
   }
   return 1;
}

INLINE int InIL(const unsigned char *k,        /* the key */
		int length)   /* the length of the key */
{  register int len = length;
   register ub4 a,b,c;
   register ub4 h, olda, oldb;
   register int i;

   /* Set up the internal state */
   a = b = 0x9e3779b9;  /* the golden ratio; an arbitrary value */
   c = HASHINITVAL;           /* the previous hash value */

   /*---------------------------------------- handle most of the key */
   while (len >= 12)
   {
      a += (k[0] +((ub4)k[1]<<8) +((ub4)k[2]<<16) +((ub4)k[3]<<24));
      b += (k[4] +((ub4)k[5]<<8) +((ub4)k[6]<<16) +((ub4)k[7]<<24));
      c += (k[8] +((ub4)k[9]<<8) +((ub4)k[10]<<16)+((ub4)k[11]<<24));
      mix(a,b,c);
      k += 12; len -= 12;
   }

   /*------------------------------------- handle the last 11 bytes */
   c += length;
   switch(len)              /* all the case statements fall through */
   {
   case 11: c+=((ub4)k[10]<<24);
   case 10: c+=((ub4)k[9]<<16);
   case 9 : c+=((ub4)k[8]<<8);
      /* the first byte of c is reserved for the length */
   case 8 : b+=((ub4)k[7]<<24);
   case 7 : b+=((ub4)k[6]<<16);
   case 6 : b+=((ub4)k[5]<<8);
   case 5 : b+=k[4];
   case 4 : a+=((ub4)k[3]<<24);
   case 3 : a+=((ub4)k[2]<<16);
   case 2 : a+=((ub4)k[1]<<8);
   case 1 : a+=k[0];
     /* case 0: nothing left to add */
   }
   olda = a; oldb = b;
   mix(a,b,c);
   /*-------------------------------------------- report the result */
   h = c & hashmask(ILBITS);
   if (!(ILtable[h >> 3] & (1 << (int)(h & 7)))) return 0;
   for (i = 1; i < ILNOOFHASH; i++) {
     a = olda; b = oldb;
     mix(a,b,c);
     h = c & hashmask(ILBITS);
     if (!(ILtable[h >> 3] & (1 << (int)(h & 7)))) return 0;
   }
   return 1;
}

INLINE int InUL(const unsigned char *k,        /* the key */
		int length)   /* the length of the key */
{  register int len = length;
   register ub4 a,b,c;
   register ub4 h, olda, oldb;
   register int i;

   /* Set up the internal state */
   a = b = 0x9e3779b9;  /* the golden ratio; an arbitrary value */
   c = HASHINITVAL;           /* the previous hash value */

   /*---------------------------------------- handle most of the key */
   while (len >= 12)
   {
      a += (k[0] +((ub4)k[1]<<8) +((ub4)k[2]<<16) +((ub4)k[3]<<24));
      b += (k[4] +((ub4)k[5]<<8) +((ub4)k[6]<<16) +((ub4)k[7]<<24));
      c += (k[8] +((ub4)k[9]<<8) +((ub4)k[10]<<16)+((ub4)k[11]<<24));
      mix(a,b,c);
      k += 12; len -= 12;
   }

   /*------------------------------------- handle the last 11 bytes */
   c += length;
   switch(len)              /* all the case statements fall through */
   {
   case 11: c+=((ub4)k[10]<<24);
   case 10: c+=((ub4)k[9]<<16);
   case 9 : c+=((ub4)k[8]<<8);
      /* the first byte of c is reserved for the length */
   case 8 : b+=((ub4)k[7]<<24);
   case 7 : b+=((ub4)k[6]<<16);
   case 6 : b+=((ub4)k[5]<<8);
   case 5 : b+=k[4];
   case 4 : a+=((ub4)k[3]<<24);
   case 3 : a+=((ub4)k[2]<<16);
   case 2 : a+=((ub4)k[1]<<8);
   case 1 : a+=k[0];
     /* case 0: nothing left to add */
   }
   olda = a; oldb = b;
   mix(a,b,c);
   /*-------------------------------------------- report the result */
   h = c & hashmask(ULBITS);
   if (!(ULtable[h >> 3] & (1 << (int)(h & 7)))) return 0;
   for (i = 1; i < ULNOOFHASH; i++) {
     a = olda; b = oldb;
     mix(a,b,c);
     h = c & hashmask(ULBITS);
     if (!(ULtable[h >> 3] & (1 << (int)(h & 7)))) return 0;
   }
   return 1;
}

#ifdef RATTSTAVA
INLINE int InXL(const unsigned char *k,        /* the key */
		int length)   /* the length of the key */
{  register int len = length;
   register ub4 a,b,c;
   register ub4 h, olda, oldb;
   register int i;

   /* Set up the internal state */
   a = b = 0x9e3779b9;  /* the golden ratio; an arbitrary value */
   c = HASHINITVAL;           /* the previous hash value */

   /*---------------------------------------- handle most of the key */
   while (len >= 12)
   {
      a += (k[0] +((ub4)k[1]<<8) +((ub4)k[2]<<16) +((ub4)k[3]<<24));
      b += (k[4] +((ub4)k[5]<<8) +((ub4)k[6]<<16) +((ub4)k[7]<<24));
      c += (k[8] +((ub4)k[9]<<8) +((ub4)k[10]<<16)+((ub4)k[11]<<24));
      mix(a,b,c);
      k += 12; len -= 12;
   }

   /*------------------------------------- handle the last 11 bytes */
   c += length;
   switch(len)              /* all the case statements fall through */
   {
   case 11: c+=((ub4)k[10]<<24);
   case 10: c+=((ub4)k[9]<<16);
   case 9 : c+=((ub4)k[8]<<8);
      /* the first byte of c is reserved for the length */
   case 8 : b+=((ub4)k[7]<<24);
   case 7 : b+=((ub4)k[6]<<16);
   case 6 : b+=((ub4)k[5]<<8);
   case 5 : b+=k[4];
   case 4 : a+=((ub4)k[3]<<24);
   case 3 : a+=((ub4)k[2]<<16);
   case 2 : a+=((ub4)k[1]<<8);
   case 1 : a+=k[0];
     /* case 0: nothing left to add */
   }
   olda = a; oldb = b;
   mix(a,b,c);
   /*-------------------------------------------- report the result */
   h = c & hashmask(XLBITS);
   if (!(XLtable[h >> 3] & (1 << (int)(h & 7)))) return 0;
   for (i = 1; i < XLNOOFHASH; i++) {
     a = olda; b = oldb;
     mix(a,b,c);
     h = c & hashmask(XLBITS);
     if (!(XLtable[h >> 3] & (1 << (int)(h & 7)))) return 0;
   }
   return 1;
}

#endif

static INLINE void StoreInEL(const unsigned char *k)
{
   register ub4 a,b,c;
   register ub4 h, olda, oldb;
   register int i;
   register int len = strlen((char *)k), length = len;

   /* Set up the internal state */
   a = b = 0x9e3779b9;  /* the golden ratio; an arbitrary value */
   c = HASHINITVAL;           /* the previous hash value */

   /*---------------------------------------- handle most of the key */
   while (len >= 12)
   {
      a += (k[0] +((ub4)k[1]<<8) +((ub4)k[2]<<16) +((ub4)k[3]<<24));
      b += (k[4] +((ub4)k[5]<<8) +((ub4)k[6]<<16) +((ub4)k[7]<<24));
      c += (k[8] +((ub4)k[9]<<8) +((ub4)k[10]<<16)+((ub4)k[11]<<24));
      mix(a,b,c);
      k += 12; len -= 12;
   }

   /*------------------------------------- handle the last 11 bytes */
   c += length;
   switch(len)              /* all the case statements fall through */
   {
   case 11: c+=((ub4)k[10]<<24);
   case 10: c+=((ub4)k[9]<<16);
   case 9 : c+=((ub4)k[8]<<8);
      /* the first byte of c is reserved for the length */
   case 8 : b+=((ub4)k[7]<<24);
   case 7 : b+=((ub4)k[6]<<16);
   case 6 : b+=((ub4)k[5]<<8);
   case 5 : b+=k[4];
   case 4 : a+=((ub4)k[3]<<24);
   case 3 : a+=((ub4)k[2]<<16);
   case 2 : a+=((ub4)k[1]<<8);
   case 1 : a+=k[0];
     /* case 0: nothing left to add */
   }
   olda = a; oldb = b;
   mix(a,b,c);
   /*-------------------------------------------- report the result */
   h = c & hashmask(ELBITS);
   ELtable[h >> 3] |= (1 << (int)(h & 7));
   for (i = 1; i < ELNOOFHASH; i++) {
     a = olda; b = oldb;
     mix(a,b,c);
     h = c & hashmask(ELBITS);
     ELtable[h >> 3] |= (1 << (int)(h & 7));
   }
}

static INLINE void StoreInFL(const unsigned char *k)
{
   register ub4 a,b,c;
   register ub4 h, olda, oldb;
   register int i;
   register int len = strlen((char *)k), length = len;

   /* Set up the internal state */
   a = b = 0x9e3779b9;  /* the golden ratio; an arbitrary value */
   c = HASHINITVAL;           /* the previous hash value */

   /*---------------------------------------- handle most of the key */
   while (len >= 12)
   {
      a += (k[0] +((ub4)k[1]<<8) +((ub4)k[2]<<16) +((ub4)k[3]<<24));
      b += (k[4] +((ub4)k[5]<<8) +((ub4)k[6]<<16) +((ub4)k[7]<<24));
      c += (k[8] +((ub4)k[9]<<8) +((ub4)k[10]<<16)+((ub4)k[11]<<24));
      mix(a,b,c);
      k += 12; len -= 12;
   }

   /*------------------------------------- handle the last 11 bytes */
   c += length;
   switch(len)              /* all the case statements fall through */
   {
   case 11: c+=((ub4)k[10]<<24);
   case 10: c+=((ub4)k[9]<<16);
   case 9 : c+=((ub4)k[8]<<8);
      /* the first byte of c is reserved for the length */
   case 8 : b+=((ub4)k[7]<<24);
   case 7 : b+=((ub4)k[6]<<16);
   case 6 : b+=((ub4)k[5]<<8);
   case 5 : b+=k[4];
   case 4 : a+=((ub4)k[3]<<24);
   case 3 : a+=((ub4)k[2]<<16);
   case 2 : a+=((ub4)k[1]<<8);
   case 1 : a+=k[0];
     /* case 0: nothing left to add */
   }
   olda = a; oldb = b;
   mix(a,b,c);
   /*-------------------------------------------- report the result */
   h = c & hashmask(FLBITS);
   FLtable[h >> 3] |= (1 << (int)(h & 7));
   for (i = 1; i < FLNOOFHASH; i++) {
     a = olda; b = oldb;
     mix(a,b,c);
     h = c & hashmask(FLBITS);
     FLtable[h >> 3] |= (1 << (int)(h & 7));
   }
}

static INLINE void StoreInIL(const unsigned char *k)
{
   register ub4 a,b,c;
   register ub4 h, olda, oldb;
   register int i;
   register int len = strlen((char *)k), length = len;

   /* Set up the internal state */
   a = b = 0x9e3779b9;  /* the golden ratio; an arbitrary value */
   c = HASHINITVAL;           /* the previous hash value */

   /*---------------------------------------- handle most of the key */
   while (len >= 12)
   {
      a += (k[0] +((ub4)k[1]<<8) +((ub4)k[2]<<16) +((ub4)k[3]<<24));
      b += (k[4] +((ub4)k[5]<<8) +((ub4)k[6]<<16) +((ub4)k[7]<<24));
      c += (k[8] +((ub4)k[9]<<8) +((ub4)k[10]<<16)+((ub4)k[11]<<24));
      mix(a,b,c);
      k += 12; len -= 12;
   }

   /*------------------------------------- handle the last 11 bytes */
   c += length;
   switch(len)              /* all the case statements fall through */
   {
   case 11: c+=((ub4)k[10]<<24);
   case 10: c+=((ub4)k[9]<<16);
   case 9 : c+=((ub4)k[8]<<8);
      /* the first byte of c is reserved for the length */
   case 8 : b+=((ub4)k[7]<<24);
   case 7 : b+=((ub4)k[6]<<16);
   case 6 : b+=((ub4)k[5]<<8);
   case 5 : b+=k[4];
   case 4 : a+=((ub4)k[3]<<24);
   case 3 : a+=((ub4)k[2]<<16);
   case 2 : a+=((ub4)k[1]<<8);
   case 1 : a+=k[0];
     /* case 0: nothing left to add */
   }
   olda = a; oldb = b;
   mix(a,b,c);
   /*-------------------------------------------- report the result */
   h = c & hashmask(ILBITS);
   ILtable[h >> 3] |= (1 << (int)(h & 7));
   for (i = 1; i < ILNOOFHASH; i++) {
     a = olda; b = oldb;
     mix(a,b,c);
     h = c & hashmask(ILBITS);
     ILtable[h >> 3] |= (1 << (int)(h & 7));
   }
}

static INLINE void StoreInUL(const unsigned char *k)
{
   register ub4 a,b,c;
   register ub4 h, olda, oldb;
   register int i;
   register int len = strlen((char *)k), length = len;

   /* Set up the internal state */
   a = b = 0x9e3779b9;  /* the golden ratio; an arbitrary value */
   c = HASHINITVAL;           /* the previous hash value */

   /*---------------------------------------- handle most of the key */
   while (len >= 12)
   {
      a += (k[0] +((ub4)k[1]<<8) +((ub4)k[2]<<16) +((ub4)k[3]<<24));
      b += (k[4] +((ub4)k[5]<<8) +((ub4)k[6]<<16) +((ub4)k[7]<<24));
      c += (k[8] +((ub4)k[9]<<8) +((ub4)k[10]<<16)+((ub4)k[11]<<24));
      mix(a,b,c);
      k += 12; len -= 12;
   }

   /*------------------------------------- handle the last 11 bytes */
   c += length;
   switch(len)              /* all the case statements fall through */
   {
   case 11: c+=((ub4)k[10]<<24);
   case 10: c+=((ub4)k[9]<<16);
   case 9 : c+=((ub4)k[8]<<8);
      /* the first byte of c is reserved for the length */
   case 8 : b+=((ub4)k[7]<<24);
   case 7 : b+=((ub4)k[6]<<16);
   case 6 : b+=((ub4)k[5]<<8);
   case 5 : b+=k[4];
   case 4 : a+=((ub4)k[3]<<24);
   case 3 : a+=((ub4)k[2]<<16);
   case 2 : a+=((ub4)k[1]<<8);
   case 1 : a+=k[0];
     /* case 0: nothing left to add */
   }
   olda = a; oldb = b;
   mix(a,b,c);
   /*-------------------------------------------- report the result */
   h = c & hashmask(ULBITS);
   ULtable[h >> 3] |= (1 << (int)(h & 7));
   for (i = 1; i < ULNOOFHASH; i++) {
     a = olda; b = oldb;
     mix(a,b,c);
     h = c & hashmask(ULBITS);
     ULtable[h >> 3] |= (1 << (int)(h & 7));
   }
}

static void InitieraBokstavsTabeller(void)
{ int i;
  int low = 0, upp = 0, del = 0;
  switch (x8bitar) {
   case 0:
    bokstavsTabell = ASCII_intern;
    tillISOTabell = intern_ISO;
    if (xTex) bokstavsTabell['/'] = '/';
    break;
   case MACCODE:
    bokstavsTabell = MAC_intern;
    tillISOTabell = MAC_ISO;
    if (xTex) bokstavsTabell['\\'] = '/';
    break;
   case DOSCODE:
    bokstavsTabell = DOS_intern;
    tillISOTabell = DOS_ISO;
    if (xTex) bokstavsTabell['\\'] = '/';
    break;
   case UTF8CODE:
   case ISOCODE:
   default:
    bokstavsTabell = ISO_intern;
    tillISOTabell = ISO_ISO;
    if (xTex) bokstavsTabell['\\'] = '/';
    break;
  }
  ISO_intern[(unsigned char) ' '] = 0;
  /* fyll i 0-flt med standardvrde i bokstavstabellen till ISO */
  for (i = 0; i < 256; i++) {
    if (tillISOTabell[i] == 0) tillISOTabell[i] = i;
    if (intern_ISO[i] == 0) intern_ISO[i] = i;
    isLowerCase[i] = isUpperCase[i] = isVowel[i] = isDelim[i] = 0;
    toLowerCase[i] = toUpperCase[i] = 0;
  }
  for (i = 0; i < 256; i++) {
    if (intern_p[i]) {
      if (intern_p[i] >= 'a') isLowerCase[i] = 1;
      else if (intern_p[i] >= 'A') isUpperCase[i] = 1;
      if (intern_p[i] == DELIMP) { 
	isDelim[i] = 1;
	del++;
      }
    }
  }
  for (i = 0; i < 256; i++) {
    if (isLowerCase[i]) {
      if (!isConsonant[i]) isVowel[i] = 1;
      toUpperCase[i] = i - 32;
      toLowerCase[i] = i;
      low++;
    } else if (isUpperCase[i]) {
      if (!isConsonant[i]) isVowel[i] = 1;
      toUpperCase[i] = i;
      toLowerCase[i] = i + 32;
      upp++;
    }
  }
  lowerCaseLetters = malloc(low + 1);
  upperCaseLetters = malloc(upp + 1);
  delimiters = malloc(del + 1);
  low = upp = del = 0;
  for (i = 0; i < 256; i++) {
    if (isLowerCase[i])
      lowerCaseLetters[low++] = i;
    else if (isUpperCase[i])
      upperCaseLetters[upp++] = i;
    else if (isDelim[i]) 
      delimiters[del++] = i;
  }
  lowerCaseLetters[low] = '\0';
  upperCaseLetters[upp] = '\0';
  delimiters[del] = '\0';
}

#ifdef SCANNER
static INLINE int SkippaRestenAvOrdet(void)
{ int t;
  while ((t = get(ordf)) != ENDOFFILE) {
    if (bokstavsTabell[t]) continue;
    if (t == '-') continue;
    if (xTex && t == '/') {
      t = get(ordf);
      if (t == '\'' || t == '`' || t == '^' || t == '"' || t == '=' || 
	  t == '.' || t == '~') continue;
    }
    return 1;
  }
  return 0;
}

static INLINE int SkippaRestenAvEpostadressen(void)
{ int t;
  while ((t = get(ordf)) != ENDOFFILE) {
    if (bokstavsTabell[t]) continue;
    if (isdigit(t) || t == '-' || t == '.') continue;
    return 1;
  }
  return 0;
}

/* SkippaInledandeVariabel hoppar ver blanka, ev citattecken och ev
   variabelnamn som inleds med dollartecken */
static void SkippaInledandeVariabel(void)
{ int u;
  u = get(ordf);
  while (u == ' ' || u == 10) u = get(ordf);
  if (u == '"') u = get(ordf);
  if (u == '$') {
    u = get(ordf);
    while (u >= 'A') u = get(ordf);
    return;
  }
  unget(u, ordf);
}

/* SkippaTill skippar MHTML-kommandon fram till angivet tecken */
static int SkippaTill(int c)
{ int u;
  u = get(ordf);
  if (c == ']' && u == 't') {
    u = get(ordf);
    if (u == 'y' &&
        (u = get(ordf)) == 'p') {
      u = get(ordf);
      while (u == ' ' || u == 10) u = get(ordf);
      if (u == '"') SkippaTill('"');
      else SkippaTill(' ');
      SkippaInledandeVariabel();
      return 0;
    } else if (u == 'e' &&
               (u = get(ordf)) == 'x' &&
               (u = get(ordf)) == 't') {
      SkippaInledandeVariabel();
      return 0;
    }
  }
  while (1) {
    if (u == ENDOFFILE || u == '\n') return 0;
    else if (u == '\\' && get(ordf) == ENDOFFILE) return 0;
    else if (u == c) return 1;
    else if (u == '[') if (SkippaTill(']') == 0) return 0;
    u = get(ordf);
  }
}

static INLINE int CheckLatin1Entity(void)
{ unsigned char entity[LANGD+1];
  int u, i = 0;
  int lo, hi, m;
  while (1) {
    u = get(ordf);
    if (u == ENDOFFILE) return ENDOFFILE;
    if (u == '\n' || u == ';' || u == ' ') break;
    if (i < LANGD) entity[i++] = u;
  }
  entity[i] = '\0';
  if (isdigit(*entity)) {
    sscanf((char *) entity, "%d", &u);
    return u;
  }
  lo = 0; hi = NOOFENTITIES - 1;
  while (lo < hi) {
    m = (hi + lo) / 2;
    i = strcmp((char *)latin1Entities[m].entity, (char *)entity);
    if (i == 0) return latin1Entities[m].letter;
    if (i < 0) lo = m + 1; else hi = m - 1;
  }
  if (lo == hi && strcmp((char *)latin1Entities[lo].entity, (char *)entity) == 0)
    return latin1Entities[lo].letter;
  return 0;
}

/* TagOrd reads the next word from the file ordf and stores it in urord.
   The word in Stava's internal format is stored in s.
   0 is returned if there is no more word (EOF), and 1 otherwise. */
#ifndef WWWSTAVA
static
#endif
int TagOrd(int *bindestreck, unsigned char *s, unsigned char *urord)
{ int t, u, i, nyrad;
 start:
  do {
    i = 0;
    *bindestreck = 0;
    do {
      u = get(ordf);
      if (u == ENDOFFILE) return 0;
      if (xHtml) {
	if (u == '&') {
	  u = CheckLatin1Entity();
	  if (u == ENDOFFILE) return 0;
	} else
	  if (u == '<') {
	    while (1) {
	      u = get(ordf);
	      if (u == ENDOFFILE) return 0;
	      if (u == '\n' || u == '>') break;
	    }
	  } else
	    if (u == '[' && x8bitar) SkippaTill(']');
      }
    } while (!(t = bokstavsTabell[u]) || t == '-');

    while (1) {
      if (t == '-' || (xTex && t == '/')) {
	/* I Tex behandlas /- precis som bara - */
	if (t == '/') if ((u = get(ordf)) != '-') {
	  if (u == '\'' || u == '`' || u == '^' || u == '~' || u == '"') {
	    unsigned char uprev = u;
	    u = get(ordf);
	    if (u != ENDOFFILE) {
	      if (uprev == '\'') {
		if (u == 'e') {
		  t = ISO_intern[(unsigned char)(u = '')]; continue;
		} else if (u == 'E') {
		  t = ISO_intern[(unsigned char)(u = '')]; continue;
		}
	      } else if (uprev == '"') {
		unsigned char newc;
		switch (u) {
		case 'a': newc = ''; break;
		case 'o': newc = ''; break;
		case 'A': newc = ''; break;
		case 'O': newc = ''; break;
		default: goto skipControl;
		}
		u = newc;
		t = ISO_intern[newc]; 
		continue;
	      }
	      skipControl:
	      if ((t = bokstavsTabell[u])) continue;
            }
	  }
	  unget(u, ordf);
	  goto ordSlut;
	}
	u = get(ordf);
	if (u == ' ' || u == '\t' || u == '\n') {
	  nyrad = (u == '\n');
	  while (1) {
	    if ((u = get(ordf)) == ENDOFFILE) goto ordSlut;
	    if (u == '\n') nyrad = 1;
	    else if (u != ' ' && u != '\t') break;
	  }
	  if (!nyrad) {
	    if (i > 0) { 
	      s[i] = urord[i] = '-';
	      i++;
	      (*bindestreck)++;
	    }
	    unget(u, ordf);
	    goto ordSlut;
	  }
	}
	if (u == '&' && xHtml) {
	  u = CheckLatin1Entity();
	  if (u == ENDOFFILE) goto ordSlut;
	}
	if ((t = bokstavsTabell[u])) {
	  if (t == '-' || (xTex && t == '/')) goto ordSlut;
	  if (i > 0) { 
	    s[i] = urord[i] = '-';
	    if (++i >= LANGD) {
	      if (!SkippaRestenAvOrdet()) return 0;
	      goto start;
	    }
	    (*bindestreck)++;
	  }
	} else goto ordSlut;
      }
#ifdef WWWSTAVA
      if (i == 0) startWord = textp - 1;
#endif
      s[i] = t;
      urord[i] = u;
      if (++i >= LANGD) {
	if (!SkippaRestenAvOrdet()) return 0;
	goto start;
      }
      if ((u = get(ordf)) == ENDOFFILE) break;
      if (u == '&' && xHtml) {
	u = CheckLatin1Entity();
	if (u == ENDOFFILE) goto ordSlut;
      }
      if (!(t = bokstavsTabell[u])) break;
    }
    if (xHtml) {
      if (u == '<' || (u == '[' && x8bitar)) unget(u, ordf);
    }
   ordSlut: ;
  } while (i < ORDMIN);
  if (u == '@') {
    if (!SkippaRestenAvEpostadressen()) return 0;
    goto start;
  }
  s[i] = urord[i] = '\0';
  return 1;
}

#ifdef API
/* TagOrdStr reads the next word from the string str and stores it in urord.
   NULL is returned if there is no more word, and a pointer to the next
   unused character otherwise. */
static unsigned char *TagOrdStr(int *bindestreck, unsigned char *str, unsigned char *urord)
{ int t, u, i, nyrad;
 start:
  do {
    i = 0;
    *bindestreck = 0;
    do {
      u = *str++;
      if (u == '\0') return NULL;
      if (xHtml) {
	if (u == '&') {
	  u = CheckLatin1Entity();
	  if (u == '\0') return NULL;
	} else
	  if (u == '<') {
	    while (1) {
	      u = *str++;
	      if (u == '\0') return NULL;
	      if (u == '\n' || u == '>') break;
	    }
	  } else
	    if (u == '[' && x8bitar) SkippaTill(']');
      }
    } while (!(t = bokstavsTabell[u]) || t == '-');

    while (1) {
      if (t == '-' || (xTex && t == '/')) {
	/* I Tex behandlas /- precis som bara - */
	if (t == '/') if ((u = *str++) != '-') {
	  if (u == '\'' || u == '`' || u == '^' || u == '~' || u == '"') {
	    unsigned char uprev = u;
	    u = *str++;
	    if (u != '\0') {
	      if (uprev == '\'') {
		if (u == 'e') {
		  t = ISO_intern[(unsigned char)(u = '')]; continue;
		} else if (u == 'E') {
		  t = ISO_intern[(unsigned char)(u = '')]; continue;
		}
	      } else if (uprev == '"') {
		unsigned char newc;
		switch (u) {
		case 'a': newc = ''; break;
		case 'o': newc = ''; break;
		case 'A': newc = ''; break;
		case 'O': newc = ''; break;
		default: goto skipControl;
		}
		u = newc;
		t = ISO_intern[newc]; 
		continue;
	      }
	      skipControl:
	      if ((t = bokstavsTabell[u])) continue;
            }
	  }
	  str--;
	  goto ordSlut;
	}
	u = *str++;
	if (u == ' ' || u == '\t' || u == '\n') {
	  nyrad = (u == '\n');
	  while (1) {
	    if ((u = *str) == '\0') goto ordSlut;
	    str++;
	    if (u == '\n') nyrad = 1;
	    else if (u != ' ' && u != '\t') break;
	  }
	  if (!nyrad) {
	    if (i > 0) { 
	      urord[i] = '-';
	      i++;
	      (*bindestreck)++;
	    }
	    str--;
	    goto ordSlut;
	  }
	}
	if (u == '&' && xHtml) {
	  u = CheckLatin1Entity();
	  if (u == '\0') goto ordSlut;
	}
	if ((t = bokstavsTabell[u])) {
	  if (t == '-' || (xTex && t == '/')) goto ordSlut;
	  if (i > 0) { 
	    urord[i] = '-';
	    if (++i >= LANGD) {
	      if (!SkippaRestenAvOrdet()) return NULL;
	      goto start;
	    }
	    (*bindestreck)++;
	  }
	} else goto ordSlut;
      }
      urord[i] = u;
      if (++i >= LANGD) {
	if (!SkippaRestenAvOrdet()) return NULL;
	goto start;
      }
      if ((u = *str) == '\0') goto ordSlut;
      str++;
      if (u == '&' && xHtml) {
	u = CheckLatin1Entity();
	if (u == '\0') goto ordSlut;
      }
      if (!(t = bokstavsTabell[u])) break;
    }
    if (xHtml) {
      if (u == '<' || (u == '[' && x8bitar)) str--;
    }
   ordSlut: ;
  } while (i < ORDMIN);
  urord[i] = '\0';
  return str;
}

#ifndef WWWSTAVA
/* StavaGetWord reads the next word from infile and stores it in word.
   Word has to be allocated (of size at least LANGD+1 (51)) before calling.
   0 is returned if there is no more word (EOF), and 1 otherwise. */
int StavaGetWord(FILE *infile, unsigned char *word)
{ unsigned char buf[LANGD+1];
  int bindestreck;
  ordf = infile;
  return TagOrd(&bindestreck, buf, word);
}
#endif

/* StavaStringGetWord reads the next word from the string str and stores 
   it in word.
   Word has to be allocated (of size at least LANGD+1 (51)) before calling.
   NULL is returned if there is no more word, and a pointer to the next
   unused character in str otherwise. */
unsigned char *StavaStringGetWord(unsigned char *str, unsigned char *word)
{ int bindestreck;
  return TagOrdStr(&bindestreck, str, word);
}
#endif /* API */
#endif /* SCANNER */

wwwstatic INLINE void SuddaBindestreck(const unsigned char *ordin, unsigned char *ordut)
{
#ifndef KOLLASAMMANSATT
  if (xSammansatta) if (ordin[1] == '-')
    ordin += 2; /* Gr om t ex c-uppgiften till uppgiften */
#endif
  while (*ordin)
    if (*ordin == '-') ordin++;
    else *ordut++ = *ordin++;
  *ordut = '\0';
}

/* Initiera initierar diverse tabeller och returnerar 1 om allt gr bra
   och 0 annars. */
static int Initiera(void)
{
  InitieraBokstavsTabeller();
#ifdef DEBUG
  if (xAndelser || xWriteSuffix) {
#else
  if (xAndelser) {
#endif
    if (InitSuf(SLfilename)) {
      PrintErrorWithText("Fel vid initiering av ndelsetabellen %s\n", SLfilename);
      return 0;
    }
#ifdef DEBUG
    if (xWriteSuffix) WriteSuffixList();
#endif
  }
  return 1;
}

int InFLSuffix(const unsigned char *ord, int len)
{
  if (xAndelser && len >= 5) {
    unsigned char word[LANGD];
    int i;
    if (strcmp((char *)ord + len - 4, "ings") == 0) { /* <V>ings <- ing */
      for (i = len - 5; i >= 0 ; i--)
	if (isVowel[ord[i]]) break;
      if (i >= 0) { /* det finns en vokal fre "ings" */
	strncpy((char *)word, (char *)ord, len - 1);
	word[len - 1] = '\0';
	if (InEL(word, len - 1)) return 1;
      }
    } else
    if (strcmp((char *)ord + len - 2, "ar") == 0) { /* ar <- are, aren */
      strncpy((char *)word, (char *)ord, len);
      word[len] = 'e';
      word[len + 1] = '\0';
      if (InEL(word, len + 1)) {
	word[len + 1] = 'n';
	word[len + 2] = '\0';
	if (InEL(word, len + 2)) return 1;
      }
    }
  }
  return InFL(ord, len);
}

#ifdef TRYALLRULES
/* SplitWord delar upp word i frledsdelen word1 och efterledet word2
efter sammansttningsanvisningarna i breaks */
static void SplitWord(const unsigned char *word, char *breaks,
		   unsigned char *word1, unsigned char *word2)
{
  int i;
  for (i = strlen((char *)word) - 1; i >= 0 && breaks[i] == ' '; i--);
  if (i < 0) i++;
  if (breaks[i] == 's') i++;
  strncpy((char *)word1, (char *)word, i);
  word1[i] = '\0';
  strcpy((char *)word2, (char *)word + i);
}
#endif /* TRYALLRULES */

#ifdef CHOOSEBESTCOMPOUNDING
static int AddCompound(struct compoundData *cdata, unsigned char *word)
{ int noofbreaks = 0, i, j;
  float len, compval;
  if (cdata->noofcompounds >= MAXNOOFCOMPOUNDS) return 0;
  for (i = 0; cdata->gBreaks[i]; i++) if (cdata->gBreaks[i] != ' ') noofbreaks++;
  len = i;
  for (i--; i >= 0 && cdata->gBreaks[i] == ' '; i--);
  len -= i;
  if (i < 0 || cdata->gBreaks[i] == 's') { len--; i++; }
#ifdef MoveSToFirstPartIfPossible
  /* Prefer kvarts-ur to kvart-sur. This gains very little. */
  if (i > 1 &&word[i-1] == 's' && bindebokstav[word[i-2]] == 's')
    if (InEL(word+i-1, strlen((char *)word+i-1)) || 
	(xAndelser && CheckSuffix(word+i-1, 0, 1))) {
      /*      printf("s-ord: %s %s\n", word, word+i-1); */
      len += 1.1;
    }
#endif
  compval = len - compfactor * (noofbreaks + 1);
  for (i = 0; i < cdata->noofcompounds; i++)
    if (compval > cdata->breakposlen[i] - compfactor * cdata->breakposparts[i]) {
      for (j = cdata->noofcompounds; j > i; j--) {
	strcpy(cdata->breakpossibilities[j], cdata->breakpossibilities[j-1]);
	cdata->breakposparts[j] = cdata->breakposparts[j-1];
	cdata->breakposlen[j] = cdata->breakposlen[j-1];
      }
      break;
    }
  strcpy(cdata->breakpossibilities[i], cdata->gBreaks);
  cdata->breakposparts[i] = noofbreaks + 1;
  cdata->breakposlen[i] = (float) len;
  cdata->noofcompounds++;
  return 1;
}
#endif /* CHOOSEBESTCOMPOUNDING */

#ifdef MORFANALYS
/* Kolla om word r sammansatt som FL* EL. Om xTillatSIFogar
   s tillt 's' i alla fogar utom mellan 1:a och 2:a delen.
   Om xTillatSIAllaFogar s tillt 's' i alla fogar. */
static INLINE int IsCompoundHelp(struct compoundData *cdata, unsigned char *word, int offset, int len)
{
  int end, tmp, firstpos, lastpos;
  char oldval;
    
  if (offset > 0 && 
      (InEL(word, len) || (xAndelser && CheckSuffix(word, 1, 1)))) {
#ifdef CHOOSEBESTCOMPOUNDING
    AddCompound(cdata, word - offset);
#else
    return 1;
#endif
  }
  lastpos = len - SLUTDELORDMIN;
  firstpos = (offset == 0 ? STARTDELORDMIN : DELORDMIN);
  for (end = firstpos; end <= lastpos; end++) {
    tmp = word[end];
    word[end] = 0;
    if (InFLSuffix(word, end)) {
      word[end] = tmp;
      /* Hantera tex toppolitiker som topp|politiker */
      if (word[end-1] == word[end-2]) {
        if (word[end-1] == tmp) continue;
	oldval = cdata->gBreaks[offset+end-1];
#ifdef DEBUG
	if (oldval != ' ')
	  printf("Inte mellanslag utan %c i pos %d (%s)\n", oldval, 
		 offset+end-1, word-offset);
#endif
	cdata->gBreaks[offset+end-1] = '<';                  
        if (IsCompoundHelp(cdata, word+end-1, offset+end-1, len-end+1)) {
#ifndef TRYALLRULES
          return 1;
#endif
        }
	cdata->gBreaks[offset+end-1] = oldval;
      }
      oldval = cdata->gBreaks[offset+end];
#ifdef DEBUG
      if (oldval != ' ')
	printf("Inte mellanslag utan %c i pos %d (%s)\n", oldval, 
	       offset+end, word-offset);
#endif
      cdata->gBreaks[offset+end] = '|';
      if (IsCompoundHelp(cdata, word+end, offset+end, len-end)) {
#ifndef TRYALLRULES
	return 1;
#endif
      }
      cdata->gBreaks[offset+end] = oldval;

      if (tmp == 's' &&
	  ((xTillatSIFogar && offset) || xTillatSIAllaFogar) &&
          bindebokstav[(unsigned char)word[end-1]] == 's' &&
	  end != lastpos) {
	oldval = cdata->gBreaks[offset+end];
#ifdef DEBUG
	if (oldval != ' ')
	  printf("Inte mellanslag utan %c i pos %d (%s)\n", oldval, 
		 offset+end, word-offset);
#endif
	cdata->gBreaks[offset+end] = 's';
        if (IsCompoundHelp(cdata, word+end+1, offset+end+1, len-end-1)) { 
#ifndef TRYALLRULES
          return 1;
#endif
        }
	cdata->gBreaks[offset+end] = oldval;
      }
    }
    else word[end] = tmp;
  }
  if (word[lastpos] == word[lastpos-1]) {
    end = lastpos + 1;
    tmp = word[end];
    if (end >= firstpos && tmp != word[lastpos]) {
      word[end] = 0;
      if (InFLSuffix(word, end)) {
	/* Hantera tex herrum som herr|rum */
	word[end] = tmp;
	if (InEL(word+end-1, len-end+1) || 
	    (xAndelser && CheckSuffix(word+end-1, 1, 1))) {
	  oldval = cdata->gBreaks[offset+end-1];
#ifdef DEBUG
	  if (oldval != ' ')
	    printf("Inte mellanslag utan %c i pos %d (%s)\n", oldval, 
		   offset+end-1, word-offset);
#endif
	  cdata->gBreaks[offset+end-1] = '<';
#ifdef CHOOSEBESTCOMPOUNDING
	  AddCompound(cdata, word-offset);
	  cdata->gBreaks[offset+end-1] = oldval;
#else
	  return 1;
#endif
        }
      }
      else word[end] = tmp;

    }
  }
  return 0;
}

/* IsCompound avgr om ett ord r sammansatt (FL* EL) */
static int IsCompound(const unsigned char *word, struct compoundData *cdata, int len)
{
  return IsCompoundHelp(cdata, (unsigned char *)word, 0, len);
}
#endif

/* Kolla om word r sammansatt som FL* EL. 
   Gr precis samma som IsCompoundHelp men kolla inte alla 
   sammansttningsmjligheter.
   Om det inte r en sammansttning returneras 0.
   Antalet led i den funna sammansttningen returneras annars.
 */
static INLINE int SimpleIsCompoundHelp(unsigned char *word, int offset, int len)
{
  int end, tmp, firstpos, lastpos, res;

  if (offset > 0 && 
      (InEL(word, len) || (xAndelser && CheckSuffix(word, 1, 1)))) {
    return 1;
  }
  lastpos = len - SLUTDELORDMIN;
  firstpos = (offset == 0 ? STARTDELORDMIN : DELORDMIN);
  for (end = firstpos; end <= lastpos; end++) {
    tmp = word[end];
    word[end] = 0;
    if (InFLSuffix(word, end)) {
      word[end] = tmp;
      /* Hantera tex toppolitiker som topp|politiker */
      if (word[end-1] == word[end-2]) {
        if (word[end-1] == tmp) continue;
        if ((res = SimpleIsCompoundHelp(word+end-1, offset+end-1, len-end+1)))
          return res + 1;
      }
      if ((res = SimpleIsCompoundHelp(word+end, offset+end, len-end)))
	return res + 1;

      if (tmp == 's' &&
	  ((xTillatSIFogar && offset) || xTillatSIAllaFogar) &&
          bindebokstav[(unsigned char)word[end-1]] == 's' &&
	  end != lastpos) {
        if ((res = SimpleIsCompoundHelp(word+end+1, offset+end+1, len-end-1)))
          return res + 1;
      }
    }
    else word[end] = tmp;
  }
  if (word[lastpos] == word[lastpos-1]) {
    end = lastpos + 1;
    tmp = word[end];
    if (end >= firstpos && tmp != word[lastpos]) {
      word[end] = 0;
      if (InFLSuffix(word, end)) {
	/* Hantera tex herrum som herr|rum */
	word[end] = tmp;
	if (InEL(word+end-1, len-end+1) || 
	    (xAndelser && CheckSuffix(word+end-1, 1, 1))) {
	  return 1;
        }
      }
      else word[end] = tmp;

    }
  }
  return 0;
}

/* SimpleIsCompound avgr om ett ord r sammansatt (FL* EL)
   Om det inte r en sammansttning returneras 0.
   Antalet led i den funna sammansttningen returneras annars.
*/
int SimpleIsCompound(const unsigned char *word, int len)
{
  return SimpleIsCompoundHelp((unsigned char *)word, 0, len);
}

/* checklevel = 1 (endast ord), 2 = (+ndelsekoll), 3 = (+sammansttningar) */
int CheckWord(const unsigned char *word, int checkLevel)
{ int len = strlen((char *)word);
  switch (InILorELbutnotUL(word, len)) {
  case -1: return 0;
  case 0: break;
  case 1: return 1;
  }
  if (checkLevel == 1) return 0;
  if (xAndelser && CheckSuffix(word, 1, 0)) return 1;
  if (checkLevel == 2) return 0;
  if (xSammansatta && SimpleIsCompound(word, len)) return 1;
  return 0;
}

/* Finns kollar om ordet word med lngden len finns och returnerar
i s fall 1. Om ordet r med i undantagsordlista returneras -1,
annars 0. */
static INLINE int Finns(const unsigned char *word, int len)
{
#ifdef MORFANALYS
  int i;
  struct compoundData cdatarec;
  cdatarec.noofcompounds = 0;
  for (i = 0; i < len; i++) cdatarec.gBreaks[i] = ' ';
  cdatarec.gBreaks[len] = '\0';
#endif /* MORFANALYS */
#ifdef TRYALLRULES      
  cdatarec.wordprefix = NULL;
#endif
#ifdef RATTSTAVA
  if (!xIntePetig) {
    int i = FyrKollaHela(word);
    if (i > 0) return 0;
  }
#endif
#ifdef CHOOSEBESTCOMPOUNDING
#ifndef VOCABULARYINUL
  if (InUL(word, len)) return -1;
#endif
#else
  switch (InILorELbutnotUL(word, len)) {
  case -1: return -1;
  case 0: break;
  case 1: return 1;
  }
#endif
  if (xAndelser && CheckSuffix(word, 1, 0)) return 1;
#ifdef CHOOSEBESTCOMPOUNDING
  switch (InILorELbutnotUL(word, len)) {
  case -1: return -1;
  case 0: break;
  case 1: 
#ifndef MORFANALYS
#ifndef WWWSTAVA
    WriteISO(word);
    printf(" [kan inte bildas med suffixreglerna]\n");
#endif
#endif
    return 1;
  }
#endif /* CHOOSEBESTCOMPOUNDING */
  if (xSammansatta) {
#ifdef CHOOSEBESTCOMPOUNDING
    IsCompound(word, &cdatarec, len);
    if (cdatarec.noofcompounds > 0) {
      if (xxDebug) {
	WriteISO(word);
	printf(" sammansatt som ");
	WriteCompound(word, cdatarec.breakpossibilities[0]);
#ifdef WWWSTAVA
        printf("<BR>");
#endif
	printf("\n");
      }
#ifdef TRYALLRULES      
      {
	unsigned char word1[LANGD], word2[LANGD];
	SplitWord(word, cdatarec.breakpossibilities[0], word1, word2);
#ifndef WWWSTAVA
#ifndef API
	if (xCollectWordsInOutput) {
	  WriteISO(word1);
	  printf("|");
	} else 
#endif
	  cdatarec.wordprefix = word1;
#endif
	if (!CheckSuffixAndTag(cdatarec.wordprefix, word2)) {
#ifndef WWWSTAVA
#ifndef API
	  if (!xCollectWordsInOutput) {
	    WriteISO(word1);
	    printf("|");
	  }
	  WriteISO(word2);
	  printf(" [kan inte bildas med suffixreglerna]\n");
#endif
#endif
	}
#ifndef WWWSTAVA
	if (!xCollectWordsInOutput) cdatarec.wordprefix = NULL;
#endif
      }
#endif /* TRYALLRULES */
      return 1;
    }
#else
    if (SimpleIsCompound(word, len)) return 1;
#endif /* not CHOOSEBESTCOMPOUNDING */
  } 
  return 0;
}

#ifndef API
#ifdef KOLLASAMMANSATT
static void DivideWord(const unsigned char *word, unsigned char *dividedWord)
{ int i, len = strlen((char *)word);
  struct compoundData cdatarec;
  cdatarec.noofcompounds = 0;
  for (i = 0; i < len; i++) cdatarec.gBreaks[i] = ' ';
  cdatarec.gBreaks[len] = '\0';
  IsCompound(word, &cdatarec, len);
  if (cdatarec.noofcompounds > 0) {
    unsigned char word1[LANGD], word2[LANGD];
    if (xxDebug) {
      int i;
      WriteISO(word);
      printf(" sammansatt som ");
      for (i = 0; i < cdatarec.noofcompounds; i++) {
	printf(" ");
	WriteCompound(word, cdatarec.breakpossibilities[i]);
	printf("(%d,%.1f)", cdatarec.breakposparts[i], cdatarec.breakposlen[i]);
      }
#ifdef WWWSTAVA
      printf("<BR>");
#endif
      printf("\n");
    }
    SplitWord(word, cdatarec.breakpossibilities[0], word1, word2);
    sprintf((char *)dividedWord, "%s-%s", word1, word2);  
  } else *dividedWord = '\0';
}
#endif /* KOLLASAMMANSATT */

#ifndef WWWSTAVA
static int is_utf8(unsigned char *str, int len) {
  int c=0, b=0, bits=0;
  int i;
  for (i = 0; i < len; i++){
    c = str[i];
    if (c > 128){
      if ((c >= 254)) return 0;
      else if (c >= 252) bits=6;
      else if (c >= 248) bits=5;
      else if (c >= 240) bits=4;
      else if (c >= 224) bits=3;
      else if (c >= 192) bits=2;
      else return 0;
      if ((i+bits) > len) return (len >= 1000); /* 0 in original version */
      while(bits > 1){
	i++;
	b = str[i];
        if (b < 128 || b > 191)
	  return 0;
	bits--;
      }
    }
  }
  return 1;
}

int OppnaNastaInfil(void)
{
  while (aktuelltFilnr < antalInfiler) {
    strcpy(ordfNamn, infiler[aktuelltFilnr++]);
    if (!(ordf = fopen(ordfNamn,"r"))) {
      PrintErrorWithText("Kan inte ppna filen %s\n", ordfNamn);
      continue;
    }
    if (!angettTeckenkod) { /* Gissa om 7- eller 8-bitsteckenkod anvnds */
      int i, t, gissadKod = x8bitar;
      unsigned char buf[1001];
      for (i = 0; i < 1000; i++) {
	if ((t = getc(ordf)) == ENDOFFILE) break;
	buf[i] = t;
      }
      buf[i] = '\0';
      if (is_utf8(buf, i)) gissadKod = UTF8CODE;
      else
      for (i = 0; i < 1000; i++) {
	if (buf[i] > 127) {
	  if (DOS_intern[buf[i]]) gissadKod = DOSCODE;
	  else if (MAC_intern[buf[i]]) gissadKod = MACCODE;
	  else gissadKod = ISOCODE;
	  break;
	}
      }
      rewind(ordf);
      /* printf("Gissadkod:%d\n", gissadKod); */
      if (gissadKod != x8bitar) {
	x8bitar = gissadKod;
	InitieraBokstavsTabeller();
      }
    }
    return 1;
  }
  return 0;
}
#endif
#endif

/* OppnaFiler ppnar alla filer och returnerar 1 om allt gr bra och
   0 annars. */
static int OppnaFiler(void)
{
#ifndef API
#ifndef WWWSTAVA
  if (antalInfiler == 0) {
    filter = 1;
    ordf = stdin;
    strcpy(ordfNamn, "stdio");
  } else {
    if (antalInfiler > 1) fleraInfiler = 1;
    if (!OppnaNastaInfil()) return 0;
  }
#endif
#endif
  /* ppna lexikonfiler: */
  if (!(ELfp = fopen(ELfilename,"rb"))) {
    PrintErrorWithText("Kan inte ppna filen %s\n", ELfilename);
    return 0;
  }
  if (!(FLfp = fopen(FLfilename,"rb"))) {
    PrintErrorWithText("Kan inte ppna filen %s\n", FLfilename);
    return 0;
  }
  if (!(ILfp = fopen(ILfilename,"rb"))) {
    PrintErrorWithText("Kan inte ppna filen %s\n", ILfilename);
    return 0;
  }
  if (!(ULfp = fopen(ULfilename,"rb"))) {
    PrintErrorWithText("Kan inte ppna filen %s\n", ULfilename);
    return 0;
  }
  return 1;
}

#ifndef API
#ifndef WWWSTAVA
static int OppnaUtfil(void)
{ char filename[FILENAMELENGTH];
  strcpy(filename, ordfNamn);
  strcat(filename, DOKUMENTORDLISTEEFTERNAMN);
  if ((xELfp = fopen(filename, "a"))) {
    inforOrdlista = 1;
    return 1;
  }
  PrintErrorWithText("Kan inte skriva p filen %s\n", filename);
  inforOrdlista = 0;
  return 0;
}

static void StangFiler(void)
{
  if (antalInfiler > 0) fclose(ordf);
  if (inforOrdlista) fclose(xELfp);
}
#endif /* not WWWSTAVA */
#endif /* not API */

static long TagExtraOrdlista(FILE *fp, char ordlista)
{ long antal = 0;
  unsigned char *s, buf[LANGD + 3];
  switch (ordlista) {
   case 'E':
    while (fgets((char *)buf, LANGD-1, fp)) {
      s = buf;
      while ((*s = dubbelBokstavsTabell[(unsigned char) (*s)])) s++;
      if (*buf) {	
	StoreInEL(buf);
#ifdef RATTSTAVA
        if (xRattstavningsforslag || !xIntePetig) LagraFyrgram(buf);
#endif
        antal++;
      }
    }
    break;
   case 'I':
    while (fgets((char *)buf, LANGD-1, fp)) {
      s = buf;
      while ((*s = dubbelBokstavsTabell[(unsigned char) (*s)])) s++;
      if (*buf) {
	StoreInIL(buf);
#ifdef RATTSTAVA
        if (xRattstavningsforslag || !xIntePetig) LagraFyrgram(buf);
#endif
        antal++;
      }
    }
    break;
   case 'F':
    while (fgets((char *)buf, LANGD-1, fp)) {
      s = buf;
      while ((*s = dubbelBokstavsTabell[(unsigned char) (*s)])) s++;
      if (*buf) {
	StoreInFL(buf);
#ifdef RATTSTAVA
        if (xRattstavningsforslag || !xIntePetig) LagraFyrgram(buf);
#endif
        antal++;
      }
    }
    break;
   case 'U':
    while (fgets((char *)buf, LANGD-1, fp)) {
      s = buf;
      while ((*s = dubbelBokstavsTabell[(unsigned char) (*s)])) s++;
      if (*buf) {
	StoreInUL(buf);
        antal++;
      }
    }
    break;
   default: ;
  }
  fclose(fp);
  return(antal);
}

static void TagStandardOrdlista(const char *name, char wordlist)
{ char fullname[FILENAMELENGTH];
  sprintf(fullname, "%s%s", libpath, name);
  if ((xELfp = fopen(fullname, "r"))) TagExtraOrdlista(xELfp, wordlist);
}

static INLINE long myfread(void *p, size_t elsize, long n, FILE *fp)
{ return fread(p, elsize, n, fp); }

static INLINE long myfwrite(void *p, size_t elsize, long n, FILE *fp)
{ return fwrite(p, elsize, n, fp); }

/* ReadLexicon ppnar alla lexikon och returnerar 1 om allt gr bra
   och 0 annars. */
static int ReadLexicon(const unsigned char *separator)
{ unsigned char slask;

  if (myfread(ELtable, sizeof(unsigned char), ELSIZE, ELfp) != ELSIZE
      || fread(&slask, sizeof(char), 1, ELfp) == 1) {
    PrintErrorWithText("%s har fel format fr att vara en lexikonfil\n",ELfilename);
    fclose(ELfp);
    return 0;
  }
  fclose(ELfp);
  if (myfread(FLtable, sizeof(unsigned char), FLSIZE, FLfp) != FLSIZE
      || fread(&slask, sizeof(char), 1, FLfp) == 1) {
    PrintErrorWithText("%s har fel format fr att vara en lexikonfil\n",FLfilename);
    fclose(FLfp);
    return 0;
  }
  fclose(FLfp);
  if (myfread(ILtable, sizeof(unsigned char), ILSIZE, ILfp) != ILSIZE
      || fread(&slask, sizeof(char), 1, ILfp) == 1) {
    PrintErrorWithText("%s har fel format fr att vara en lexikonfil\n",ILfilename);
    fclose(ILfp);
    return 0;
  }
  fclose(ILfp);
  if (myfread(ULtable, sizeof(unsigned char), ULSIZE, ULfp) != ULSIZE
      || fread(&slask, sizeof(char), 1, ULfp) == 1) {
    PrintErrorWithText("%s har fel format fr att vara en lexikonfil\n",ULfilename);
    fclose(ULfp);
    return 0;
  }
  fclose(ULfp);
#ifdef RATTSTAVA
  if (xRattstavningsforslag || !xIntePetig) 
    if (!InitRattstava(fyrgramfilename, separator)) return 0;
  if (xRattstavningsforslag) {
    FILE *f = fopen(XLfilename, "rb");
    if (!f) {
      PrintErrorWithText("Kan inte ppna frekvensfilen %s", XLfilename);
      return 0;
    }
    if (myfread(XLtable, 1, XLSIZE, f) != XLSIZE
        || fread(&slask, 1, 1, f) == 1) {
      PrintErrorWithText("%s har fel format fr att vara en frekvensfil\n",
              XLfilename);
      fclose(f);
      return 0;
    }
  }
#endif
#ifndef API
#ifndef WWWSTAVA
  { int i;
    long antal = 0;
    for (i = 0; i < antalOrdlistor; i++) {
#ifdef DEBUG
      printf("Lser ord frn %s\n", ordlistor[i]);
#endif
      if (!(xELfp = fopen(ordlistor[i], "r")))
        PrintErrorWithText("Kan inte lsa ordlistan %s\n", ordlistor[i]);
      else antal += TagExtraOrdlista(xELfp, ordlisttyp[i]);
    }
#ifdef DEBUG
    sprintf(stavaerrorbuf, "%ld stycken ord i extraordlistorna lagrade\n", antal);
    if (xPrintError) fprintf(stderr, "%s", stavaerrorbuf);
#endif
  }
#endif /* not WWWSTAVA */
#endif /* not API */
  if (!xKort) { /* KE/KF/KILFILENAME innehller redan fljande ordlistor */
    if (xForkortningar) TagStandardOrdlista(XFORKORTNINGAR, 'I');
    if (xNamn) TagStandardOrdlista(XNAMN, 'I');
    if (xDatatermer) {
      TagStandardOrdlista(XDATATERMEREL, 'E');
      TagStandardOrdlista(XDATATERMERFL, 'F');
      TagStandardOrdlista(XDATATERMERIL, 'I');
    }
  }
  if (xTex) TagStandardOrdlista(XTEX, 'I');
  return 1;
}

#ifndef API
#ifndef WWWSTAVA
static int TagEnDokumentordlista(const char *filename, char otyp)
{ FILE *fp = fopen(filename, "r");
  if (fp == NULL) return 0;
#ifdef DEBUG
  printf("Lser ord frn %s\n", filename);
#endif
  TagExtraOrdlista(fp, otyp);
  return 1;
}

static void TagDokumentordlistor(void)
{ char filename[FILENAMELENGTH];
  char *s;
  laserOrdlista = 0;
  strcpy(filename, ordfNamn);
  s = filename + strlen(filename);
  strcpy(s, DOKUMENTORDLISTEEFTERNAMN);
  if (TagEnDokumentordlista(filename, 'E')) laserOrdlista = 1;
  strcpy(s, DOKUMENTELEFTERNAMN);
  if (TagEnDokumentordlista(filename, 'E')) laserOrdlista = 1;
  strcpy(s, DOKUMENTFLEFTERNAMN);
  if (TagEnDokumentordlista(filename, 'F')) laserOrdlista = 1;
  strcpy(s, DOKUMENTILEFTERNAMN);
  if (TagEnDokumentordlista(filename, 'I')) laserOrdlista = 1;
  strcpy(s, DOKUMENTULEFTERNAMN);
  if (TagEnDokumentordlista(filename, 'U')) laserOrdlista = 1;
}

static void SkrivEttLexikon(const char *filename, unsigned char table[], long size)
{ FILE *fp;
  if (!(fp = fopen(filename,"wb"))) {
    PrintErrorWithText("Kan inte ppna filen %s\n", filename);
    return;
  }
  myfwrite(table, sizeof(unsigned char), size, fp);
  fclose(fp);
}

static void SkrivSuffixlexikon(const char *infilename, char *outfilename)
{ FILE *infp, *outfp;
  int c;
  if (!(infp = fopen(infilename,"r"))) {
    PrintErrorWithText("Kan inte ppna filen %s\n", infilename);
    return;
  }
  if (!(outfp = fopen(outfilename,"w"))) {
    PrintErrorWithText("Kan inte ppna filen %s\n", outfilename);
    return;
  }
  while ((c = getc(infp)) != EOF) putc(c, outfp);
  fclose(infp);
  fclose(outfp);
}

static void SkrivLexikon(void)
{
  if (*utELfilename) SkrivEttLexikon(utELfilename, ELtable, ELSIZE);
  if (*utFLfilename) SkrivEttLexikon(utFLfilename, FLtable, FLSIZE);
  if (*utILfilename) SkrivEttLexikon(utILfilename, ILtable, ILSIZE);
  if (*utULfilename) SkrivEttLexikon(utULfilename, ULtable, ULSIZE);
  if (*utSLfilename) SkrivSuffixlexikon(SLfilename, utSLfilename);
}

static unsigned char LasFilnamn(unsigned char valjare, char *filnamn, int *i, 
		       int argc, char **argv)
{
  if (*i + 1 < argc)
    if (argv[*i + 1][0] != '-') {
      ++(*i);
      if (strlen(filnamn) >= FILENAMELENGTH) {
	strncpy(filnamn, argv[*i], FILENAMELENGTH - 1);
	filnamn[FILENAMELENGTH - 1] = '\0';
      } else strcpy(filnamn, argv[*i]);
      return 0;
    }
  sprintf(stavaerrorbuf, "Filnamn mste ges efter -%c.\n", valjare);
  if (xPrintError) PrintLocale(stderr, stavaerrorbuf);
  return 1;
}
#endif /* not WWWSTAVA */
#endif /* not API */

INLINE void VersalerGemena(register const unsigned char *ordin, register unsigned char *ord,
			   register unsigned char *Ord)
{ register int i;
  int baraGemena, baraVersaler;
  baraGemena = baraVersaler = 1;
  for (i = 0; ordin[i] != '\0'; i++) {
    if (isUpperCase[ordin[i]]) {
      baraGemena = 0;
      ord[i] = toLowerCase[ordin[i]];
    } else {
      baraVersaler = 0;
      ord[i] = ordin[i];
    }
  }
  if (baraGemena) ord[0] = Ord[0] = '\0';
  else {
    ord[i] = '\0';
    if (baraVersaler) {
      Ord[0] = ordin[0];
      strcpy((char *)Ord + 1, (char *)ord + 1);
    } else Ord[0] = '\0';
  }
}

/* Kolla vilken ordlistetyp som angivits, E, I, F, U eller S */
static char KollaOrdlistetyp(char otyp)
{
  switch (otyp) {
   case '\0': return 'E';
   case 'E': return 'E';
   case 'e': return 'E';
   case 'I': return 'I';
   case 'i': return 'I';
   case 'F': return 'F';
   case 'f': return 'F';
   case 'U': return 'U';
   case 'u': return 'U';
   case 'S': return 'S';
   case 's': return 'S';
   default: return 'E'; /* standardval */
  }
}

/* KollaOrd kollar ordet som det r, med bara sm bokstver och, om det
   bara innehller versaler, med stor begynnelsebokstav */
wwwstatic INLINE int KollaOrd(const unsigned char *ordin)
{ unsigned char ord[LANGD + 3], Ord[LANGD + 3];
  int len = strlen((char *)ordin);
#ifdef TAGGSTAVA
  nooftags = 0;
#endif
  switch (Finns(ordin, len)) {
  case -1: return 0;
  case 0: break;
  case 1: return 1;
  }
  VersalerGemena(ordin,ord,Ord);
  if (*ord) switch (Finns(ord, len)) {
  case -1: return 0;
  case 0: break;
  case 1: return 1;
  }
  if (*Ord) { /* bara versaler */
    if (xAcceptCapitalWords) return 1;
    if (Finns(Ord, len) == 1) return 1;
  }
  return 0;
}

/* KollaDelar kollar alla ordets delar som r avskiljda med bindestreck
   var fr sej och returnerar sant d alla finns */
wwwstatic INLINE int KollaDelar(const unsigned char *ordin, unsigned char *ord2)
{ unsigned char *t;
  do {
    t = ord2;
    while (*ordin && *ordin != '-') *t++ = *ordin++;
    *t = '\0';
    if (t - ord2 >= ORDMIN)
      if (!KollaOrd(ord2)) return 0;
  } while (*ordin++);
  return 1;
}

#ifdef RATTSTAVA
static unsigned char *AllocateEmptyString()
{ unsigned char *s = malloc(1);
  *s = '\0';
  return s;
}

unsigned char *StavaSkrivRattelser(struct correctionSet *cset) {
  int i;
  unsigned char *res;
  if (cset->noOfCorrections == 0) res = AllocateEmptyString();
  else {
    int separatorLength = strlen((char *) wordSeparator);
    int len = 1 + (cset->noOfCorrections - 1) * separatorLength;
    unsigned char *s, *t;
    for (i = 0; i < cset->noOfCorrections; i++)
      len += strlen((char *) cset->corrections[i] + 1);
#ifdef MORFANALYS
#ifndef WWWSTAVA
    if (xxDebug)
      len += cset->noOfCorrections * 5;
#endif
#endif
    res = (unsigned char *) malloc(len);
    s = res;
    for (i = 0; i < cset->noOfCorrections; i++) {
      if (i > 0) {
	strcpy((char *) s, (char *) wordSeparator);
	s += separatorLength;
      }
#ifdef MORFANALYS
#ifndef WWWSTAVA
      if (xxDebug) {
	char buf[100];
	sprintf(buf, "(%d)", (int) cset->corrections[i][0]);
	strcpy((char *) s, buf);
	s += strlen(buf);
      }
#endif
#endif
      for (t = cset->corrections[i] + 1; *t; t++)
	*s++ = intern_ISO[*t];
      *s = '\0';
      free(cset->corrections[i]);
    }
  }
  free(cset->corrections);
  return res;
}
#endif

#ifndef API
#ifndef WWWSTAVA
/* EnvArg hmtar en environmentvariabel och bryter upp den i argv och argc */
static int EnvArg(const char *namn, int *argc, char ***argv)
{ unsigned char *s, *start, *env, **v;
  int antal = 0, len, i;

  if (!(env = (unsigned char *)getenv(namn))) return(-1);
  while (*env == ' ' || *env == '\t') env++;
  s = env;
  while (*s) {
    antal++;
    while (*s && *s != ' ' && *s != '\t') s++;
    while (*s == ' ' || *s == '\t') s++;
  }
  *argc = antal + 1;
  v = calloc(antal + 2, sizeof(char *));
  *argv = (char **) v;
  for (i = 1, s = env; i <= antal; i++) {
    start = s;
    len = 0;
    while (*s && *s != ' ' && *s != '\t') { len++; s++; }
    v[i] = calloc(len + 1, sizeof(char));
    strncpy((char *)v[i], (char *)start, len);
    while (*s == ' ' || *s == '\t') s++;
  }
  return(antal);
}

#ifdef KOLLASAMMANSATT
static INLINE int StavaOrd(const unsigned char *ordin, unsigned char *urord, int bindestreck)
{ unsigned char ord2[LANGD + 3], ord3[LANGD + 3];
  if (bindestreck) SuddaBindestreck(ordin, ord2);
  else strcpy((char *)ord2, (char *)ordin);
  DivideWord(ord2, ord3);
  if (strcmp((char *)ordin, (char *)ord3) == 0) antalRiktiga++;
  else {
    WriteISO(*ord3 ? ord3 : ord2);
    printf("\n");
    if (bindestreck) {
      if (*ord3) antalFel++; else antalOsammansatta++;
    }
  }
  return 0;
}

#else /* not KOLLASAMMANSATT */

/* StavaOrd returnerar 0 om ordet var rtt och 1 om ordet var fel */
static INLINE int StavaOrd(const unsigned char *ordin, unsigned char *urord, int bindestreck)
{ unsigned char ord2[LANGD + 3];
  if (KollaOrd(ordin)) return 0;
  if (bindestreck) {
    int i = strlen((char *)ordin);
    if (ordin[i - 1] == '-') {
      strcpy((char *)ord2, (char *)ordin);
      i--;
      ord2[i] = '\0';
      if (InFLSuffix(ord2, i)) return 0;
      if (isUpperCase[ord2[0]]) {
	ord2[0] = toLowerCase[ord2[0]];
	if (InFLSuffix(ord2, i)) return 0;
      }
      SuddaBindestreck(ordin, ord2);
      return !InFLSuffix(ord2, strlen((char *)ord2));
    }
    if (xSammansatta) if (KollaDelar(ordin, ord2)) return 0;
    SuddaBindestreck(ordin, ord2);
    if (KollaOrd(ord2)) return 0;
  }
  if (!xInvertera) {
#ifdef RATTSTAVA
    if (xRattstavningsforslag) {
      struct correctionSet cset;
      int corrected;
      unsigned char *corr;
      if (fleraInfiler) printf("%s:\t", ordfNamn);
      PrintLocale(stdout, (char *) urord);
      printf(": ");
      corrected = GenerateCorrections(&cset, (unsigned char *) ordin);
      corr = StavaSkrivRattelser(&cset);
      if (corrected)
	PrintLocale(stdout, (char *) corr);
      else
	printf("? hittar inga liknande ord");
      free(corr);
      putchar('\n');
    } else
#endif
#ifndef TRYALLRULES
    {
      if (fleraInfiler) printf("%s:\t", ordfNamn);
      PrintLocale(stdout, (char *) urord);
      printf("\n");
    }
#else
    {
      PrintLocale(stdout, (char *) urord);
      PrintLocale(stdout, " [oknt ord]\n");
    }
#endif
  }
  if (inforOrdlista) fprintf(xELfp,"%s\n", (const char *) urord);
  if (xEndastEtt) {
    StoreInEL(ordin);
#ifdef RATTSTAVA
    if (xRattstavningsforslag || !xIntePetig) LagraFyrgram(ordin);
#endif
  }
  return 1;
}
#endif /* not KOLLASAMMANSATT */

void KollaArg(int filnamnTillatna, int argc, char **argv)
{ int i, fel = 0;
  unsigned char *s;
  char otyp;

  if (ordlistor) {
    ordlistor = realloc(ordlistor,
				  sizeof(char *) * (antalOrdlistor + argc/2));
    ordlisttyp = realloc(ordlisttyp,
				  sizeof(char) * (antalOrdlistor + argc/2));
    enstakaOrd = realloc(ordlisttyp,
				  sizeof(char) * (antalEnstakaOrd + argc/2));
  } else {
    ordlistor = malloc(sizeof(char *) * (argc/2));
    ordlisttyp = malloc(sizeof(char) * (argc/2));
    enstakaOrd = malloc(sizeof(char) * (argc/2));
  }
  if (filnamnTillatna) infiler = malloc(sizeof(char *) * argc);
  
  for (i = 1; i < argc; i++) {
    s = (unsigned char *) argv[i];
    if (*s == '-') {
      s++;
      while (*s) {
	switch (*(s++)) {
	 case 'q': /* Ls inte filens ordlista */
	 case 'Q': xLasOrdlista = 0; break;

	 case 'e': /* Endast ett felmeddelande fr varje felstavat ord */
	 case 'E': xEndastEtt = 1; break;
	
	 case 'k': /* Kort lista med fel - acceptera s mycket som mjligt */
	 case 'K':
	  xKort = xEndastEtt = 1;
	  xSammansatta = xAndelser = 1;
	  xForkortningar = xNamn = xDatatermer = 1;
	  break;

#ifdef RATTSTAVA
	 case '2': /* ge rttelsefrslag p avstnd tv ocks */
	           xMaxOneError = xRattstavningsforslag = 0; break;

	 case 'r': /* Ge rttstavningsfrslag */
	 case 'R': xRattstavningsforslag = 1; break;

         case 'B': /* tillt inte generering av sammansatta ord vid stavningsfrslag */
	           xGenerateCompounds = 0;
		   xRattstavningsforslag = 1; break;
      
         case 'b': /* tillt generering av sammansatta ord vid stavningsfrslag */
	           xGenerateCompounds = xRattstavningsforslag = 1; break;
      
	 case 'p': /* Var petig, dvs kolla rimliga bokstavskombinationer */
	 case 'P': xIntePetig = 0; xAcceptCapitalWords = 0; break;
#endif
	 case 's': /* Dummyvljare, tidigare godknn sammansttningar */
#ifdef TRYALLRULES
                   /* Dela upp taggarna/lemmana p olika rader i utskriften */ 
                   xCollectWordsInOutput = 0;
#endif
	           break;

#ifdef KOLLASAMMANSATT
	 case 'T': /* Testa konstanten i sammansttningsoptimeringen */
	  if (i + 1 < argc && argv[i+1][0] != '-' &&
	      sscanf(argv[i+1], "%f", &compfactor)) {
	    i++;
	  } else PrintErrorWithText("Ett tal mste ges efter -T\n","");
	  break;
#endif	  

	 case 'S': /* Godknn inte sammansttningar */
	           xSammansatta = 0; break;

	 case 'a': /* Dummyvljare, tidigare godknn ndelser */
#ifdef DEBUG
	           /* Skriv ut suffixlistan */
	           xWriteSuffix = 1;
#endif
	           break;

	 case 'A': /* Godknn inte ndelser */
	           xAndelser = 0; break;

	 case 'f': /* Ls in tillggsordlistan med frkortningar */
	 case 'F': xForkortningar = 1; break;

	 case 'n': /* Ls in tillggsordlistan med namn */
	 case 'N': xNamn = 1; break;

	 case 'D':
	           /* Sl p avlusningsmod */
	           xxDebug = 1; break;

	 case 'd': /* Ls in tillggsordlistan med datatermer */
	           xDatatermer = 1; break;

	 case 't': /* Ls in tillggsordlistan med TeX-termer */
	           xTex = 1; break;

	 case 'h': /* ignorera HTML-koder */
	           xHtml = 1; break;

	 case '1':
	 case '6':
	           x8bitar = UTF8CODE; /* Anvnd UTF-8 */
	           angettTeckenkod = 1; break;
	 case '8': x8bitar = ISOCODE; /* Anvnd ISO 8859-1 */
	           angettTeckenkod = 1; break;
	 case '7': x8bitar = 0; /* Anvnd normala 7-bitstecken */
                   angettTeckenkod = 1; break;

	 case 'v': /* Invertera beteende */
	           xInvertera = 1; break;

	 case 'V': /* Rapportera version */
	  printf("%s\n", VERSION);
	  break;

	 case 'w': /* Stavningskolla ett enda ord */
	 case 'W':
	  if (i + 1 < argc && argv[i+1][0] != '-') {
	    char buf[1001];
	    char *s = argv[i + 1];
	    if (x8bitar == UTF8CODE) {
	      buf[1000] = '\0';
	      utf8string2iso(buf, 1000, (unsigned char *) s);
	      s = buf;
	    }
	    enstakaOrd[antalEnstakaOrd] = malloc(strlen(s) + 1);
	    strcpy((char *)enstakaOrd[antalEnstakaOrd], s);
	    antalEnstakaOrd++;
	    i++;
	  } else PrintErrorWithText("Ett ord mste ges efter -w\n", "");
	  break;
	  
	 case 'o': /* Ls tillggsordlista */
	 case 'O':
	  otyp = KollaOrdlistetyp((char) *s);
	  *s = '\0';
	  if (i + 1 < argc) {
	    ordlistor[antalOrdlistor] = malloc(strlen(argv[i+1]) + 1);
	    ordlisttyp[antalOrdlistor] = otyp;
	  }
	  if (LasFilnamn('o', ordlistor[antalOrdlistor], &i, argc, argv))
	    fel++;
	  else antalOrdlistor++;
	  break;
	  
	 case 'i': /* Infr ord i dokumentordlistan */
	 case 'I': xInforOrdlista = 1; break;

	 case 'l': /* Ls frn annat lexikon */
	 case 'L':
	  otyp = KollaOrdlistetyp((char) *s);
	  *s = '\0';
	  switch (otyp) {
	   case 'E': 
	    if (LasFilnamn('l', ELfilename, &i, argc, argv)) fel++;
	    break;
	   case 'F': 
	    if (LasFilnamn('l', FLfilename, &i, argc, argv)) fel++;
	    break;
	   case 'I': 
	    if (LasFilnamn('l', ILfilename, &i, argc, argv)) fel++;
	    break;
	   case 'U': 
	    if (LasFilnamn('l', ULfilename, &i, argc, argv)) fel++;
	    break;
	   case 'S': 
	    if (LasFilnamn('l', SLfilename, &i, argc, argv)) fel++;
	    break;
	  }
	  break;

	 case 'u': /* Utlexikonfilnamn */
	 case 'U':
	  otyp = KollaOrdlistetyp((char) *s);
	  *s = '\0';
	  switch (otyp) {
	   case 'E': 
	    if (LasFilnamn('u', utELfilename, &i, argc, argv)) fel++;
	    else xSkrivLexikon = xEndastEtt = 1;
	    break;
	   case 'F': 
	    if (LasFilnamn('u', utFLfilename, &i, argc, argv)) fel++;
	    else xSkrivLexikon = xEndastEtt = 1;
	    break;
	   case 'I': 
	    if (LasFilnamn('u', utILfilename, &i, argc, argv)) fel++;
	    else xSkrivLexikon = xEndastEtt = 1;
	    break;
	   case 'U': 
	    if (LasFilnamn('u', utULfilename, &i, argc, argv)) fel++;
	    else xSkrivLexikon = xEndastEtt = 1;
	    break;
	   case 'S':
	    if (LasFilnamn('u', utSLfilename, &i, argc, argv)) fel++;
	    else xSkrivLexikon = 1;
	    break;
	  }
	  break;
	 case 'H': /* Hjlp */
	 case '?': fel++;
	  break;
	 default:
	  sprintf(stavaerrorbuf, "Oknd vljare: %c\n", *(s-1));
	  if (xPrintError) PrintLocale(stderr, stavaerrorbuf);
	  fel++;
	  break;
	}
      }
    } else {
      if (filnamnTillatna) infiler[antalInfiler++] = argv[i]; 
      else PrintErrorWithText("Oknd vljare: %s\n", argv[i]);
    }
  }
  if (fel) {
    if (xPrintError) {
      char tmpbuf[1000];
      fprintf(stderr, "%s\n", VERSION);
      PrintLocale(stderr, "Syntax:\n");
      fprintf(stderr,
	      " %s [-o ordlista] [-fndqiekhtrB2p7AS] infiler\n", PROGRAMNAME);
/* [-l lexikonfil] [-u utlexikonfil] [-w ord] */
      PrintLocale(stderr,
	      " f(rkortningar), n(amn), d(atatermer), e(n felrapport per ord),\n");
      PrintLocale(stderr,
	      " k (kort lista med fel, samma som -fnde), t(exfil), h(tml-fil),\n");
      sprintf(tmpbuf, " q (ls inte %s-fil), i(nfr i %s-fil), \n",
	      DOKUMENTORDLISTEEFTERNAMN, DOKUMENTORDLISTEEFTERNAMN);
      PrintLocale(stderr, tmpbuf);
      PrintLocale(stderr,
	      " r(ttelsefrslag)\n");
      PrintLocale(stderr,
	      " B (tillt inte generering av sammansatta ord), 2 (ge fler rttelsefrslag)\n");
      /*
	PrintLocale(stderr,
	" p (extra petig kontroll)\n");
      */
      PrintLocale(stderr,
	      " A (anvnd inte ndelseregler), S (godknn inte sammansatta ord)\n");
      PrintLocale(stderr,
	" Teckenkod fr indata: 7 (gammal 7-bitskod), 8 (Latin-1), 16 (UTF-8)\n");
      PrintLocale(stderr,
	      "Fullstndig information finns p webben p\n");
      PrintLocale(stderr,
	      "http://www.nada.kth.se/stava/manual.html\n");
    }
    exit(1);
  }
}

static void InitLocale(void)
{ char *locale = setlocale(LC_CTYPE, "");
  if (!locale) {
    fprintf(stderr, "Can't get locale!\n");
    utf8locale = 1;
  } else
  utf8locale = (strstr(locale, "utf8") || strstr(locale, "UTF8") || 
		strstr(locale, "utf-8") || strstr(locale, "UTF-8"));
}

int main(int argc, char **argv)
{ unsigned char ordin[LANGD + 3], urord[LANGD + 3];
  char **envv;
  int envc;
  int bindestreck;

  *ELfilename = '\0'; *utELfilename = '\0';
  *FLfilename = '\0'; *utFLfilename = '\0';
  *ILfilename = '\0'; *utILfilename = '\0';
  *ULfilename = '\0'; *utULfilename = '\0';
  *stavaerrorbuf = '\0';
  InitLocale();
  if (!(libpath = getenv(LIBPATHVARIABLE))) libpath = LIBPATH;
#ifdef TRYALLRULES
  sprintf(SLfilename, "%s%s.wt", libpath, SLFILENAME);
#else
  sprintf(SLfilename, "%s%s", libpath, SLFILENAME);
#endif
#ifdef GENERERA
  if (argc == 2 && (strcmp(argv[1], "-g") == 0 || strcmp(argv[1], "-G") == 0))
    xGrundform = 1; /* Skriv ut grundformen */
#else
  if (EnvArg(ENVIRONMENTVARIABLE, &envc, &envv) > 0) 
    KollaArg(0, envc, envv);
  KollaArg(1, argc, argv);
#endif
  if (!*ELfilename) sprintf(ELfilename, "%s%s", libpath, xKort ? KELFILENAME : ELFILENAME);
  else xKort = 0; /* s inlsning av diverse lexikon inte hindras */
  if (!*FLfilename) sprintf(FLfilename, "%s%s", libpath, xKort ? KFLFILENAME : FLFILENAME);
  if (!*ILfilename) sprintf(ILfilename, "%s%s", libpath, xKort ? KILFILENAME : ILFILENAME);
  if (!*ULfilename) sprintf(ULfilename, "%s%s", libpath, xKort ? KULFILENAME : ULFILENAME);
#ifdef RATTSTAVA
  sprintf(XLfilename, "%s%s", libpath, XLFILENAME);
  sprintf(fyrgramfilename, "%s%s", libpath, XFYRGRAM);
#endif
  if (!Initiera()) exit(1);
  if (!OppnaFiler()) exit(1);
  if (!ReadLexicon((const unsigned char *) " ")) exit(1);
#ifdef GENERERA
  { unsigned char line[200];
  while (fgets((char *)line, 200, ordf)) GenereraFormer(line);
  }
#else
  if (antalEnstakaOrd > 0) {
    int i;
    unsigned char *t, *u;
    for (i = 0; i < antalEnstakaOrd; i++) {
      bindestreck = 0;
      strcpy((char *)urord, (char *)enstakaOrd[i]);
      for (t = ordin, u = urord; (*t = bokstavsTabell[*u]) != 0; t++, u++)
	if (*t == '-') bindestreck++;
      if (strlen((char *)ordin) >= ORDMIN) {
	if (StavaOrd(ordin, urord, bindestreck) == 0) {
	  PrintLocale(stdout, (char *) urord);
	  printf("\n");
	}
      }
    }
  }
  if (antalEnstakaOrd == 0 || antalInfiler > 0) {
    do {
      if (xLasOrdlista) TagDokumentordlistor();
      if (xInforOrdlista) OppnaUtfil();
      if (xInvertera) {
	while (TagOrd(&bindestreck, ordin, urord))
	  if (StavaOrd(ordin, urord, bindestreck) == 0) {
	    PrintLocale(stdout, (char *) urord);
	    printf("\n");
	  }
      } else {
	while (TagOrd(&bindestreck, ordin, urord))
	  StavaOrd(ordin, urord, bindestreck);
      }
      StangFiler();
    } while (OppnaNastaInfil());
  }
  if (xSkrivLexikon) SkrivLexikon();
#ifdef KOLLASAMMANSATT
  { long total = antalRiktiga + antalOsammansatta + antalFel;
  if (total > 0) {
    fprintf(stderr, "Korrekta sammansttningar: %5.2f %% (%ld)\n", 
	    100.0 * antalRiktiga / total, antalRiktiga);
    fprintf(stderr, "Osammansatta:              %5.2f %% (%ld)\n", 
	    100.0 * antalOsammansatta / total, antalOsammansatta);
    fprintf(stderr, "Fel sammansttningar:      %5.2f %% (%ld)\n", 
	    100.0 * antalFel / total, antalFel);
  }
  }
#endif
#endif /* not GENERERA */
  return 0;
}
#endif  /* not WWWSTAVA */
#endif  /* not API */

#ifdef API
/* StavaVersion returns a string that uniquely identifies the version. */
const char *StavaVersion(void)
{ return VERSION; }

/* StavaReadLexicon must be called before any other function in the API. */
/* Returns 1 if the initialization goes well and 0 otherwise. */
int StavaReadLexicon(const
                     char *libPath, /* path to library directory (ending with /) */
		     int compound, /* 1 to allow compound words */
		     int suffix,   /* 1 to apply suffix rules */
		     int abbrev,   /* 1 to add abbreviation word list */
		     int name,     /* 1 to add name list */
		     int comp,     /* 1 to add list of computer words */
		     int correct,  /* 1 to be able to correct words */
		     const unsigned char *separator) /* separator between corrections */
{
  libpath = libPath;
#ifndef WWWSTAVA
  x8bitar = ISOCODE; /* change to UTF8CODE if needed */
#endif
  angettTeckenkod = 1;
  xSammansatta = compound;
  xAndelser = suffix;
  xForkortningar = abbrev;
  xNamn = name;
  xDatatermer = comp;
#ifdef RATTSTAVA
  xRattstavningsforslag = correct;
  sprintf(XLfilename, "%s%s", libpath, XLFILENAME);
  sprintf(fyrgramfilename, "%s%s", libpath, XFYRGRAM);
#endif
  xKort = xForkortningar && xNamn && xDatatermer;
  xPrintError = 0; /* Skriv inte ut felmeddelanden p stderr */
  sprintf(ELfilename, "%s%s", libpath, xKort ? KELFILENAME : ELFILENAME);
  sprintf(FLfilename, "%s%s", libpath, xKort ? KFLFILENAME : FLFILENAME);
  sprintf(ILfilename, "%s%s", libpath, xKort ? KILFILENAME : ILFILENAME);
  sprintf(ULfilename, "%s%s", libpath, xKort ? KULFILENAME : ULFILENAME);
#ifdef TRYALLRULES
  sprintf(SLfilename, "%s%s.wt", libpath, SLFILENAME);
#else
  sprintf(SLfilename, "%s%s", libpath, SLFILENAME);
#endif
  *stavaerrorbuf = '\0';
  if (!Initiera() || !OppnaFiler() || !ReadLexicon(separator)) return 0;
  return 1;
}

/* StavaAddWord adds a word to one of the word lists of Stava. This means
   that in the future the word will be accepted. There are four types of
   word lists:
   E  - (Ending) for words that may appear alone or as last part of compound
        Examples: medium, fotboll, blare
   F  - (First) for words that may appear as first or middle part of compound
        Examples: medie, fotbolls, bl
   I  - (Individual) for words that may appear only as individual words
        Examples: hej, du
   U  - (exception) for words that should not be accepted
        Examples: parantes, mssigt
  Returns 1 if word could be stored and 0 otherwise. */
int StavaAddWord( const
		  unsigned char *word, /* the word to be entered */
                  char type)  /* word list type (E, F, I, or U) */
{ unsigned char buf[LANGD + 3];
  int i;
#ifdef RATTSTAVA
  int positiveword = 1;
#endif
  for (i = 0; i < LANGD; i++)
    if (!(buf[i] = bokstavsTabell[word[i]])) break;
  if (i == LANGD) return 0; /* too long word */
  switch (KollaOrdlistetyp(type)) {
    case 'E': StoreInEL(buf); break;
    case 'F': StoreInFL(buf); break;
    case 'I': StoreInIL(buf); break;
    case 'U': StoreInUL(buf); 
#ifdef RATTSTAVA
      positiveword = 0; 
#endif
      break;
    default: return 0;
  }
#ifdef RATTSTAVA
  if (positiveword && (xRattstavningsforslag || !xIntePetig)) 
    LagraFyrgram(buf);
#endif
  return 1;
}

/* StavaWord checks if a word is correctly spelled.
   Returns 1 if the word is correctly spelled and 0 otherwise. */
int StavaWord(
	      const unsigned char *word)     /* word to be checked */
{ unsigned char buf[LANGD + 3], ord2[LANGD + 3];
  int i, bindestreck = 0;
  for (i = 0; i < LANGD; i++) {
    if (!(buf[i] = bokstavsTabell[word[i]])) break;
    if (buf[i] == '-') bindestreck++;
  }
  if (i == LANGD) return 0; /* too long word */
  if (i < ORDMIN) return 1; /* short words are always accepted */
  if (KollaOrd(buf)) return 1;
  if (bindestreck) {
    if (buf[i - 1] == '-') {
      i--;
      buf[i] = '\0';
      if (InFLSuffix(buf, i)) return 1;
      SuddaBindestreck(buf, ord2);
      return InFLSuffix(ord2, strlen((char *)ord2));
    }
    if (xSammansatta) if (KollaDelar(buf, ord2)) return 1;
    SuddaBindestreck(buf, ord2);
    if (KollaOrd(ord2)) return 1;
  }
  return 0;
}

#ifdef RATTSTAVA
/* StavaCorrectWord checks if a word is correctly spelled and returns
   ordered proposals of replacements if not. The most likely word is
   presented first.
   Before StavaCorrectWord is called the first time StavaReadLexicon
   must have been called with the parameter correct=1.

   Returns NULL if the word is correctly spelled and a string of 
   proposed replacements otherwise. If no proposed replacement is
   found the empty string is returned. */
unsigned char *StavaCorrectWord(
	      const unsigned char *word)     /* word to be corrected */
{ unsigned char buf[LANGD + 3], ord2[LANGD + 3];
  struct correctionSet cset;
  int i, bindestreck = 0;
  if (!xRattstavningsforslag) return NULL; /* not correctly initialized */
  for (i = 0; i < LANGD; i++) {
    if (!(buf[i] = bokstavsTabell[word[i]])) break;
    if (buf[i] == '-') bindestreck++;
  }
  if (i == LANGD) return NULL; /* too long word */
  if (i < ORDMIN) return NULL; /* short words are always accepted */
  if (KollaOrd(buf)) return NULL;
  if (bindestreck) {
    if (xSammansatta) if (KollaDelar(buf, ord2)) return NULL;
    SuddaBindestreck(buf, ord2);
    if (KollaOrd(ord2)) return NULL;
  }
  GenerateCorrections(&cset, buf);
  return StavaSkrivRattelser(&cset);
}

/* StavaCorrectCompound checks if a word is a correctly spelled compound
   and then returns ordered proposals of replacements. The most likely word is
   presented first.
   Before StavaCorrectCompound is called the first time StavaReadLexicon
   must have been called with the parameter correct=1.

   Returns NULL if the word is not a correctly spelled compound and a string 
   of proposed replacements otherwise. If no proposed replacement is
   found the empty string is returned. */
unsigned char *StavaCorrectCompound(
	      const unsigned char *word)     /* word to be corrected */
{ unsigned char buf[LANGD + 3];
  struct correctionSet cset;
  int i;
#ifdef MORFANALYS
  struct compoundData cdatarec;
  cdatarec.noofcompounds = 0;
#endif /* MORFANALYS */
  if (!xRattstavningsforslag) return NULL; /* not correctly initialized */
  for (i = 0; i < LANGD; i++) {
    if (!(buf[i] = bokstavsTabell[word[i]])) break;
  }
  if (i == LANGD) return NULL; /* too long word */
  if (i < ORDMIN) return NULL; /* short words are always accepted */
  if (InILorELbutnotUL(buf, i) != 0) return NULL;
  if (xAndelser && CheckSuffix(buf, 0, 0)) return NULL;
#ifdef MORFANALYS
  if (!IsCompound(buf, &cdatarec, i)) return NULL;
#else
  if (!SimpleIsCompound(buf, i)) return NULL;
#endif
  GenerateSimpleCorrections(&cset, buf);
  return StavaSkrivRattelser(&cset);
}
#endif /* RATTSTAVA */

#ifdef MORFANALYS
#ifdef SPLITCOMPOUNDSCCNOTUSED
/* StavaAnalyzeCompound analyzes a compund. 
   Before StavaAnalyzeCompound is called the first time StavaReadLexicon
   must have been called.

   Returns 0 if the word is not a correctly spelled compound and 1 otherwise.
*/
void StavaAnalyzeCompound(
			 unsigned char *res, /* result will appear here */
			 const unsigned char *word) /* word to be analyzed */
{ unsigned char buf[LANGD + 3], ord[LANGD + 3], Ord[LANGD + 3];
  int i, len, bindestreck = 0;
  struct compoundData cdatarec;
  cdatarec.noofcompounds = 0;
  strcpy((char *) res, (char *) word);
  for (i = 0; i < LANGD; i++) {
    cdatarec.gBreaks[i] = ' ';
    if (!(buf[i] = bokstavsTabell[word[i]])) break;
    if (buf[i] == '-') bindestreck = 1;
  }
  cdatarec.gBreaks[i] = '\0';
  if (i == LANGD) return; /* too long word */
  if (i < ORDMIN) return; /* short words are always accepted */
  len = i;
  if (InILorELbutnotUL(buf, len) != 0) return;
  if (xAndelser && CheckSuffix(buf, 0, 1)) return;
  IsCompound(buf, &cdatarec, len);
  if (cdatarec.noofcompounds == 0) {
    VersalerGemena(buf,ord,Ord);
    if (*ord) IsCompound(ord, &cdatarec, len);
    if (*Ord && cdatarec.noofcompounds == 0) IsCompound(Ord, &cdatarec, len);
  }
  if (bindestreck && cdatarec.noofcompounds == 0 ) {
    unsigned char *ordin = buf, *t;
    char totbreaks[LANGD + 3], *b;
    int breakstartpos, ordlen;
    for (i = 0; i < LANGD; i++) totbreaks[i] = ' ';
    totbreaks[i] = '\0';
    do {
      t = ord; b = cdatarec.gBreaks;
      breakstartpos = ordin - buf;
      while (*ordin && *ordin != '-') {
	*t++ = *ordin++;
	*b++ = ' ';
      }
      *t = *b = '\0';
      ordlen = strlen((char *) ord);
      if (ordlen >= ORDMIN &&
	  !InILorELbutnotUL(ord, ordlen) &&
	  (!xAndelser || !CheckSuffix(ord, 0, 1))) {
	cdatarec.noofcompounds = 0;
	IsCompound(ord, &cdatarec, ordlen);
	if (cdatarec.noofcompounds > 0) {
	  cdatarec.breakpossibilities[0][ordlen] = '\0';
	  strcpy(totbreaks + breakstartpos, 
		 cdatarec.breakpossibilities[0]);
	  if (*ordin == '-') totbreaks[ordin - buf] = ' ';
	}
      }
    } while (*ordin++);
    cdatarec.noofcompounds = 1;
    totbreaks[len] = '\0';
    strcpy(cdatarec.breakpossibilities[0], totbreaks);
  }
  if (cdatarec.noofcompounds == 0) return;
  *res = '\0';
  StringWriteCompound(res, word, cdatarec.breakpossibilities[0]);
  return;
}
#endif

/* StavaGetAllCompounds analyzes a compund. 
   Before it is called the first time StavaReadLexicon
   must have been called.

   Find all possible compound interpretations of a word,
   unless the word is found as a non-compound in the dictionary.
*/
int StavaGetAllCompounds(
			 unsigned char *res, /* result will appear here, and it will be many '\0'-terminated strings, ended with two consecutive '\0' */
			 const unsigned char *word) /* word to be analyzed */
{ unsigned char buf[LANGD + 3], ord[LANGD + 3], Ord[LANGD + 3];
  int i, len, bindestreck = 0;
  unsigned char * start;
  int wordlen = strlen((char *) word);
  struct compoundData cdatarec;
  cdatarec.noofcompounds = 0;
  res[0] = 0;
  res[1] = 0;

  if(InILorELbutnotUL(word, wordlen))
    return 0;

  strcpy((char *) res, (char *) word);
  res[wordlen+1] = 0;
  for (i = 0; i < LANGD; i++) {
    cdatarec.gBreaks[i] = ' ';
    if (!(buf[i] = bokstavsTabell[word[i]])) break;
    if (buf[i] == '-') bindestreck = 1;
  }
  cdatarec.gBreaks[i] = '\0';
  if (i == LANGD) return 0; /* too long word */
  if (i < ORDMIN) return 0; /* short words are always accepted */
  len = i;
  if (InILorELbutnotUL(buf, len) != 0) return 0;
  if (xAndelser && CheckSuffix(buf, 0, 0)) return 0;
  IsCompound(buf, &cdatarec, len);
  if (cdatarec.noofcompounds == 0) {
    VersalerGemena(buf,ord,Ord);
    if (*ord) IsCompound(ord, &cdatarec, len);
    if (*Ord && cdatarec.noofcompounds == 0) IsCompound(Ord, &cdatarec, len);
  }
  if (bindestreck && cdatarec.noofcompounds == 0 ) {
    unsigned char *ordin = buf, *t;
    char totbreaks[LANGD + 3], *b;
    int breakstartpos, ordlen;
    for (i = 0; i < LANGD; i++) totbreaks[i] = ' ';
    totbreaks[i] = '\0';
    do {
      t = ord; b = cdatarec.gBreaks;
      breakstartpos = ordin - buf;
      while (*ordin && *ordin != '-') {
	*t++ = *ordin++;
	*b++ = ' ';
      }
      *t = *b = '\0';
      ordlen = strlen((char *) ord);
      if (ordlen >= ORDMIN &&
	  !InILorELbutnotUL(ord, ordlen) &&
	  (!xAndelser || !CheckSuffix(ord, 0, 1))) {
	cdatarec.noofcompounds = 0;
	IsCompound(ord, &cdatarec, ordlen);
	if (cdatarec.noofcompounds > 0) {
	  cdatarec.breakpossibilities[0][ordlen] = '\0';
	  strcpy(totbreaks + breakstartpos, cdatarec.breakpossibilities[0]);
	  if (*ordin == '-') totbreaks[ordin - buf] = ' ';
	}
      }
    } while (*ordin++);
    cdatarec.noofcompounds = 1;
    totbreaks[len] = '\0';
    strcpy(cdatarec.breakpossibilities[0], totbreaks);
  }
  if (cdatarec.noofcompounds == 0) return 0;

  start = res;
  for(i = 0; i < cdatarec.noofcompounds; i++) {
    StringWriteCompound(start, word, cdatarec.breakpossibilities[i]);
    len = strlen((char *) start);
    start[len] = 0;
    start[len+1] = 0;
    start = start + len + 1;
  }
  return 1;
}

#ifdef TAGGSTAVA
/* StavaTagWord returns all part-of-speech tags of a word from
   an open word class. 
   If lemmatize=1 the lemma will also be included.
   If lemmatize=0 the lemma will not be included.
   Before StavaTagWord is called the first time StavaReadLexicon
   must have been called.

   Returns NULL if the word is unknown.
*/
char *StavaTagWord(
		   const unsigned char *word,     /* word to be tagged */
                   int lemmatize)          /* whether lemma form should be reported */
{ unsigned char buf[LANGD + 3], ord2[LANGD + 3];
  int i, bindestreck = 0;
  extern char *stavawordtags__;
  stavawordtags__ = NULL;
  xLemmatize = lemmatize;
  nooftags = 0;
  for (i = 0; i < LANGD; i++) {
    if (!(buf[i] = bokstavsTabell[word[i]])) break;
    if (buf[i] == '-') bindestreck++;
  }
  if (i == LANGD) return NULL; /* too long word */
  if (i < ORDMIN) return NULL; /* short words are always accepted */
  if (KollaOrd(buf)) return stavawordtags__;
  if (bindestreck) {
    if (xSammansatta) if (KollaDelar(buf, ord2)) return stavawordtags__;
    SuddaBindestreck(buf, ord2);
    if (KollaOrd(ord2)) return stavawordtags__;
  }
  return NULL;
}

#endif /* TAGGSTAVA */
#endif /* MORFANALYS */

/* StavaLastErrorMessage returns a message describing the last error message
that occurred. Returns empty string if no error message occurred since last
call to StavaLastErrorMessage. */
const char *StavaLastErrorMessage(void)
{ 
  static char lasterror[400];
  strcpy(lasterror, stavaerrorbuf);
  *stavaerrorbuf = '\0';
  return lasterror;
}
#endif /* API */

#ifdef WWWSTAVA
int BaraMellanslagTillStartWord(void)
{ unsigned char *s;
  for (s = endWord; s < startWord; s++)
    if (*s != ' ') return 0;
  endWord = startWord;
  return 1;
}

void SkrivUtTillStartWord(void)
{ unsigned char *s;
  for (s = endWord; s < startWord; s++) {
#ifdef TRYALLRULES
    if (*s == '\n') {
      printf("</TD></TR><TR><TD></TD></TR></TABLE></TD>\n");
      printf("</TR></TABLE>\n");
      printf("<TABLE><TR>");
    }
#else
    if (*s == '\n' && !xHtml) printf("<BR>\n");
#endif
    else putchar(tillISOTabell[*s]);
  }
  endWord = startWord;
}

void SkrivUtOrd(void)
{ unsigned char *s;
  if (xHtml && (*textp == '<' || *textp == '['))
    endWord = textp;
  else 
    endWord = textp - 1;
  for (s = startWord; s < endWord; s++) putchar(tillISOTabell[*s]);
}

#endif /* WWWSTAVA */
