/* Rttstavningsprogram. Version 2.63 2013-04-03
   Copyright (C) 1990-2013
   Joachim Hollman och Viggo Kann
   joachim@algoritmica.se viggo@nada.kth.se
*/

/******************************************************************************

    This file is part of Stava.

    Stava is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Stava is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Stava.  If not, see <http://www.gnu.org/licenses/>.

******************************************************************************/

struct correctionSet {
  int noOfCorrections;
  unsigned char **corrections;
};

/* wordSeparator r den strng som skrivs ut mellan tv rttelsefrslag. */
const extern unsigned char *wordSeparator;

/* rattstava.h - grnssnitt till rattstava.c */
/* InitRattstava ppnar fyrgramsfilen och initierar hjlpstrukturer.
   separator r den strng som skrivs ut mellan tv rttelsefrslag. */
extern int InitRattstava(const char *fyrgramfilename, 
			 const unsigned char *separator);
/* LagraFyrgram ser till att ett ords alla fyrgram r tilltna */
extern void LagraFyrgram(const unsigned char *ord);
/* FyrKollaHela kollar om ett ords alla fyrgram r tilltna */
extern int FyrKollaHela(const unsigned char *ord);

/* GenerateSimpleCorrections genererar rangordnade rttelsefrslag p avstnd 1 i EL och IL frn 
   ett potentiellt riktigt stavat ord word. Rttelsefrslagen lggs i cset.
   Returnerar 0 om inget frslag kunde genereras och 1 annars. */
extern int GenerateSimpleCorrections(struct correctionSet *cset, unsigned char *word);
/* GenerateCorrections genererar rangordnade rttelsefrslag till word.
   Rttelsefrslagen lggs i cset.
   Returnerar 0 om inget frslag kunde genereras och 1 annars. */
extern int GenerateCorrections(struct correctionSet *cset, unsigned char *word);
