/* 
 * API for splitting Swedish compounds.
 *
 * Requires Stava and some language specific data files.
 *
 * Copyright (C) 2016
 * Authors of this file: Jonas Sjbergh and Viggo Kann
 * jsh@csc.kth.se viggo@csc.kth.se
*/

/******************************************************************************

    This file is part of Stava.

    Stava is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Stava is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Stava.  If not, see <http://www.gnu.org/licenses/>.

******************************************************************************/

/* InitStava and InitSplitCompoundsData, must be called before any other method is called.
 * They read datafiles and initialize things.
 */
void InitStava(const char * stava_lib_path); // directory where Stava's data files are
void InitSplitCompoundsData(const char * lib_path); // directory where the compound data files are

/* StavaSplitCompound analyzes a compund and splits it in the optimal way. 
 * Before StavaSplitCompound is called the first time StavaReadLexicon/InitStava
 * and InitSplitCompoundsData must have been called.
*/
void StavaSplitCompound(
			char * res, /* split word; non-compound gets "" here,  */
			const char * word); /* word to be split */

/* StavaAnalyzeCompound is the same as StavaSplitCompound in C */
void StavaAnalyzeCompound(
			 unsigned char *res, /* result will appear here */
			 const unsigned char *cword); /* word to be analyzed */
