/* Program som testar Taggstavas API. Det frvntar sej ett ord
   per rad och matar ut ordets taggar.

   Copyright (C) Viggo Kann 2016-07-24
   */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "libstava.h"

int main(void)
{ char buf[1001];
#if DEFAULTCODE==4 /* UTF8CODE=4 */
  utf8locale = 1;
#endif
  if (!StavaReadLexicon(LIBPATH,1,1,0,0,0,1,(const unsigned char *) ",")) {
    fprintf(stderr, "Kan inte initiera Stava\n");
    exit(1);
  }
  while (fgets(buf, 1000, stdin)) {
    buf[strcspn(buf, "\r\n")] = '\0';
#if DEFAULTCODE==4 /* UTF8CODE=4 */
      char tmpbuf[1001];
      tmpbuf[1000] = '\0';
      utf8string2iso(tmpbuf, 1000, (unsigned char *) buf);
      strcpy(buf, tmpbuf);
#endif
    char *s;
    if ((s = StavaTagWord((unsigned char *) buf, 1))) {
      PrintLocale(stdout, buf);
      PrintLocale(stdout, ": ");
      PrintLocale(stdout, s);
      PrintLocale(stdout, "\n");
      free(s);
    } else
      if (!StavaWord((unsigned char *) buf)) {
	PrintLocale(stdout, buf);
	PrintLocale(stdout, ": [oknt ord]\n");
      } else {
	PrintLocale(stdout, buf);
	PrintLocale(stdout, ": [oknd tagg]\n");
      }
  }
  return 0;
}
