/***************************************************************************
                                databank.hpp
                             -------------------
                               Thu Nov 14 2002
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DATA_BANK_H
#define DATA_BANK_H

#include <string>
#include "types.hpp"


/**
 * Databank, the evaluation tool's data storage module 
 */
class Databank
{
  public:
    Databank();

    /* Forces the output buffers to write their data to file */
    void flushOutputBuffers() const; 

    /* Gets a reference to a input buffer */
    DSource& getBuffer(const std::string &buffName);

    /* Get the contents of a counter stored in a container */
    double getCnt(const std::string &cntName, const std::string &mapName) const;

    /* Get a reference to a counter container */
    const CntMap& getCntMap(const std::string &mapName) const;

    /* Gets a reference to a filter */
    EvFilter& getFilter(const std::string &filterName); 

    /* Gets a reference to a output buffer */
    XOutput& getOutBuffer(const std::string &buffName); 

    /* Get the contents of a string variable stored in a container */
    std::string getVar(const std::string &varName, const std::string &mapName) const;

    /* Get a reference to a string container */
    const DataMap& getVarMap(const std::string &mapName);

    /* Get a reference to a counter stored in a container, 
       if the variable is inexistant it is created */
    double& giveCntRef(const std::string &cntName, const std::string &mapName);

    /* Get a reference to a string variable stored in a container, 
       if the variable is inexistant it is created */
    std::string& giveVarRef(const std::string &varName, const std::string &mapName);

    /* Adds an output buffer */
    void addOutputBuffer(const std::string &buffName, const std::string &fileName);

    /* Adds an input buffer */
    void addInputBuffer(const std::string &buffName, const std::string &fileName, const std::string &format);

    /* Adds a filter */
    void addFilter(const std::string &filterName, const std::string &fileName);

    ~Databank();
    BufferMap buffers;      /* input buffers */
    CntConMap counterCons;  /* counter containers */
    OutputBuffMap outputs;  /* output buffers */
    VarConMap varCons;      /* string containers */
    FilterMap filters;      /* filter objects */
  
  private:    
    void delFilters();          /* Delete all the filters added to the databank*/
    void delInputBuffers();     /* Delete all the input buffers added to the databank*/
    void delOutputBuffers();    /* Delete all the output buffers added to the databank*/
};

/* Gets a pointer to the global instance of the databank */
Databank* getDatabank(); 



#endif
