/***************************************************************************
                                 evutil.cpp
                             -------------------
                               Wed Dec 4 2002
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "evutil.hpp"

#include <sstream>

using namespace std;


Ch2XML::Ch2XML(const char* const str)
{
  xstr_ = XMLString::transcode(str);
}


Ch2XML::Ch2XML(const std::string &str)
{
  xstr_ = XMLString::transcode(str.c_str());
}


const XMLCh* Ch2XML::toXML() const
{
  return xstr_;
}


Ch2XML::~Ch2XML()
{
  delete [] xstr_;
}


XML2Ch::XML2Ch(const XMLCh* const xstr)
{
  str_ = XMLString::transcode(xstr);
}


const char* const XML2Ch::toC_str() const
{
  return str_;
}

std::string XML2Ch::toStr() const
{
  return std::string(str_);
}


XML2Ch::~XML2Ch()
{
  delete [] str_;
}

std::string dbl2str(double num) {
     std::ostringstream sts;
     sts << num; 
     return sts.str();
}


std::string int2str(int num) {
     std::ostringstream sts;
     sts << num; 
     return sts.str();
}

int str2int(const std::string &str) {
     int num;
     std::istringstream sts(str);
     sts >> num;
     return num;
}

