/***************************************************************************
                                   evutil.hpp
                             -------------------
                               Wed Dec 4 2002
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef EV_UTIL_H
#define EV_UTIL_H

#include <string>

#include <xercesc/util/XMLString.hpp>

XERCES_CPP_NAMESPACE_USE

/** 
 * Converts a c++ STL string or a c-style string 
 * (char*) to a native Xerces XML string
 */
class Ch2XML
{
  public:
    Ch2XML(const char* const str);
    Ch2XML(const std::string &str);

    /* Output the converted string as a native Xerces XML string */
    const XMLCh* toXML() const; 
    ~Ch2XML();
  private:
    XMLCh* xstr_;
};


/**
 * Converts a native Xerces XML string to a c++
 * string or a c-style string (char*) 
 */
class XML2Ch
{
  public:
    XML2Ch(const XMLCh* const xstr);

    /* Output the converted string as a c-style string (char*) */
    const char* const toC_str() const;

    /* Output the converted string as a c++ STL string */
    std::string toStr() const;
    ~XML2Ch();
  private:
    char* str_;
};

std::string dbl2str(double num);     /* converts a double to a string  */
std::string int2str(int num);        /* converts a integer to a string */
int str2int(const std::string &str); /* converts a string to a integer */

#endif
