/***************************************************************************
                                  execut.cpp
                             -------------------
                               Sat Oct 19 2002
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "execute.hpp"

#include <vector>

static struct Execute_handler
{
    Execute_handler() : skip_until_next_outmost(false), prepared(false)
    {
	outmost.reserve(512);
	v.reserve(512);
	c.reserve(512);
	skip.reserve(512);
    }
    ~Execute_handler()
    {
	for(unsigned int i = 0; i < v.size(); i++)
	    delete v[i];
	for(unsigned int i = 0; i < c.size(); i++)
	    delete c[i];
    }   
    
    void add(Execute_base *exec, bool om, bool constant)
    {
	if(!constant)
	{
	    v.push_back(exec);
	    outmost.push_back(om);
	    skip.push_back(skip.size());
	}
	else
	    c.push_back(exec);
    }

    bool execute() {
	if(!prepared)
	    prepare();
	skip_until_next_outmost = false;
	for(unsigned int i = 0; i < v.size();) {
	    if(skip_until_next_outmost) {
		i = skip[i];
		skip_until_next_outmost = false;
		continue;
	    }
	    if (outmost[i] && skip_over_next_outmost) {
		 i = skip[i];
		 skip_over_next_outmost = false;
		 continue;
	    }

	    if(!v[i]->execute() && outmost[i]) {
		return false;
	    }
	    i++;
	}
	return true;
    }

    void prepare() {
	int skip_to = v.size();
	for(int i = (int)v.size() - 1; i >= 0; i--) {
	     skip[i] = skip_to;
	     if(outmost[i])
		  skip_to = i + 1;
	}
    }

    void clear()
    {
	outmost.clear();
	v.clear();
	c.clear();
	skip.clear();
	prepared = false;
    }

    std::vector<bool> outmost;
    std::vector<Execute_base *> v;
    std::vector<Execute_base *> c;
    std::vector<int> skip;
    bool skip_until_next_outmost;
    bool skip_over_next_outmost;
    bool prepared;
} handler;


void queue(Execute_base *new_exec, bool outmost, bool constant)
{
    handler.add(new_exec, outmost, constant);
}

bool execute()
{
    return handler.execute();
}

void set_skip(bool b)
{
    handler.skip_until_next_outmost = b;
}

void set_long_skip(bool b)
{
    handler.skip_over_next_outmost = b;
}

void reset_execute()
{
    handler.clear();
}
