/***************************************************************************
                                  internal.hpp
                             -------------------
                               Tue February 4 2002
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <string>

#include "types.hpp"

// General functions
bool do_(bool);
bool ignore(bool b);
bool exenext(bool);
bool exenextelse(bool);

// Setter functions
bool setdbl(double&, double);
bool setstr(std::string &, std::string);

// Compare functions
bool eq_str(std::string str1, std::string str2);
bool eq_dbl(double i1, double i2);
bool leq_dbl(double d1, double d2);

// Convertion functions
int         double2int(double d);
double      string2int(std::string);
double      string2double(std::string);
std::string int2string(double);
std::string double2string(double num);

// Math functions
double divide(double n, double d);
double multiply(double n, double d);
double subtract(double n, double d);
double add(double n, double d);
double modulus(double n, double d);
bool   increment(double &cnt);
bool   increment_byval(double &cnt, double val);
bool   decrement(double &cnt);
bool   decrement_byval(double &cnt, double val);
bool   rand_con(double prob);

// String functions
std::string concat_2(std::string, std::string);
std::string concat_3(std::string, std::string, std::string);
std::string concat_4(std::string, std::string, std::string, std::string);
bool        match_regex(std::string &result, const std::string buffer, const std::string expr);
bool        match_substr(std::string &result, const std::string buffer, const std::string expr);
bool        match_start(std::string &result, const std::string buffer, const std::string expr);

// Counter variable functions
double       &cnt2(std::string s, std::string cont);
double       &cnt1(std::string s);
double        lookupcnt2(std::string s, std::string cont);
double        lookupcnt1(std::string s);
const CntMap &cntmap(std::string cont);

// String variable functions
std::string   &var2(std::string s, std::string cont);
std::string   &var1(std::string s);
std::string    lookup2(std::string s, std::string cont);
std::string    lookup1(std::string s);
const DataMap &varmap(std::string cont);

// File functions
DSource  &in(std::string f);
EvFilter &filter(std::string s);
XOutput  &out(std::string s);
bool      outfilexml(std::string buffName, std::string fileName);
bool      infileplain(std::string buffName, std::string fileName);
bool      infilexml(std::string buffName, std::string fileName);
bool      stdinplain(std::string buffName);
bool      filterplain(std::string filterName, std::string fileName);

// Read functions
bool field_1(DSource &buffer, std::string idelim, std::string edelim, std::string &var1);
bool field_2(DSource &buffer, std::string idelim, std::string edelim, std::string &var1, std::string &var2);
bool field_3(DSource &buffer, std::string idelim, std::string edelim, std::string &var1, std::string &var2, std::string &var3);
bool field_4(DSource &buffer, std::string idelim, std::string edelim, std::string &var1, std::string &var2, std::string &var3, std::string &var4);
bool field_5(DSource &buffer, std::string idelim, std::string edelim, std::string &var1, std::string &var2, std::string &var3, std::string &var4, std::string &var5);
bool xfield(DSource &buffer, std::string root, std::string datanode, std::string data1, std::string data2, std::string &var1, std::string &var2);

// Filter functions
bool basic_filter(EvFilter &filter, std::string idelim, std::string edelim, std::string &var);

// Output functions
bool cout_print(std::string s);
bool cout_progress(std::string s);
bool out_int(XOutput &buffer, std::string varName, double varData, std::string section);
bool out_dbl(XOutput &buffer, std::string varName, double varData, std::string section);
bool out_str(XOutput &buffer, std::string varName, std::string varData, std::string section);
bool out_intmap(XOutput &buffer, const CntMap& intmap, std::string section);
bool out_dblmap(XOutput &buffer, const CntMap& intmap, std::string section);
bool out_strmap(XOutput &buffer, const DataMap& strmap, std::string section);
bool out_allint(XOutput &buffer);
bool out_alldbl(XOutput &buffer);
bool out_allstr(XOutput &buffer);

// Logic functions
bool logic_not(bool logic);
bool logic_and_2(bool logic1, bool logic2);
bool logic_and_3(bool logic1, bool logic2, bool logic3);
bool logic_and_4(bool logic1, bool logic2, bool logic3, bool logic4);
bool logic_or_2(bool logic1, bool logic2);
bool logic_or_3(bool logic1, bool logic2, bool logic3);
bool logic_or_4(bool logic1, bool logic2, bool logic3, bool logic4);

// Example functions
bool basic_example(XOutput &buffer, std::string section, std::string exName, std::string kvar, std::string kvardata, std::string var1, std::string var1data, std::string var2, std::string var2data);

bool basic_majority5(std::string &major, std::string var1, std::string var2, std::string var3, std::string draw);

/**
 * Dummy function taking two dummy parameters and returning bool
 */
bool bool_dummy2(double dummy1, double dummy2);

