/***************************************************************************
                                 outxml.cpp
                             -------------------
                               Wed Dec 4 2002
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "outxml.hpp"

#include <ctime>
#include <sstream>

#include "evutil.hpp"
#include "evexp.hpp"

XOutput::XOutput(const std::string &filename) {
     filename_ = filename;  

     impl_ = DOMImplementationRegistry::getDOMImplementation(Ch2XML("Core").toXML());
     doc_  = impl_->createDocument(0, Ch2XML("evaloutput").toXML(), 0);
     doc_->setStandalone(true);
     root_ = doc_->getDocumentElement();
     time_t stamp = time(0);
     std::string datestr(ctime(&stamp));
     datestr.resize(datestr.size() - 1);  
     root_->setAttribute(Ch2XML("date").toXML(), Ch2XML(datestr).toXML());
}

DOMElement* XOutput::createSection(const std::string &section) {
     DOMElement *secelement   = doc_->createElement(Ch2XML(section).toXML());
     DOMText *newlinestart    = doc_->createTextNode(Ch2XML("\n").toXML());
     DOMText *newlineend      = doc_->createTextNode(Ch2XML("\n").toXML());
     DOMText *newlinestartele = doc_->createTextNode(Ch2XML("\n").toXML());
     root_->appendChild(newlinestart);
     secelement->appendChild(newlinestartele);
     root_->appendChild(secelement);
     root_->appendChild(newlineend);
     sections_[section] = secelement;
     return secelement;
}


void XOutput::flush() {
     try {
	  filetarget_ = new LocalFileFormatTarget(filename_.c_str());
     }     
     catch (const XMLException& toCatch) {
	  std::ostringstream sts;
	  sts << XML2Ch(toCatch.getMessage()).toStr() << ": " << filename_;
	  EvExp e;
	  e.section = "XML Output file writer";
	  e.error = "Xerces Error during opening outfile (file access error?)";
	  e.data = sts.str();
	  throw e;
     }
     
     DOMWriter *writer = impl_->createDOMWriter();
     writer->setFeature(Ch2XML("format-pretty-print").toXML(), true); // doesn't work
     writer->setEncoding(Ch2XML("ISO-8859-1").toXML());
     writer->writeNode(filetarget_, *doc_);
     delete writer;
}


DOMElement* XOutput::getSectionElement(const std::string &section) {
     SectionMap::const_iterator iter = sections_.find(section);
     if (iter != sections_.end()) {
	  return iter->second;
     }
     return createSection(section);
}


void XOutput::writeexample(const std::string &section, const std::string &subsection, const std::string &mainvar, const std::string &mainvardata, const std::string &var1, const std::string &var1data, const std::string &var2, const std::string &var2data) {
     DOMText *newlinesec       = doc_->createTextNode(Ch2XML("\n").toXML());
     DOMText *newlinesubsecst  = doc_->createTextNode(Ch2XML("\n").toXML());
     DOMText *newlinesubsecmed = doc_->createTextNode(Ch2XML("\n").toXML());
     DOMText *newlinesubsecend = doc_->createTextNode(Ch2XML("\n").toXML());
     DOMElement *secelement    = getSectionElement(section);
     DOMElement *subsectionele = doc_->createElement(Ch2XML(subsection).toXML());
     subsectionele->setAttribute(Ch2XML(mainvar).toXML(), Ch2XML(mainvardata).toXML());
     DOMElement *var1ele = doc_->createElement(Ch2XML(var1).toXML());
     DOMElement *var2ele = doc_->createElement(Ch2XML(var2).toXML());
     DOMText *var1txt    = doc_->createTextNode(Ch2XML(var1data).toXML());
     DOMText *var2txt    = doc_->createTextNode(Ch2XML(var2data).toXML());
     var1ele->appendChild(var1txt);
     var2ele->appendChild(var2txt);
     subsectionele->appendChild(newlinesubsecst);
     subsectionele->appendChild(var1ele);
     subsectionele->appendChild(newlinesubsecmed);
     subsectionele->appendChild(var2ele);
     subsectionele->appendChild(newlinesubsecend);
     secelement->appendChild(subsectionele);
     secelement->appendChild(newlinesec);
}

void XOutput::writevar(const std::string &section, const std::string &tagname, const int data) {
     writevar(section, tagname, int2str(data));
}

void XOutput::writevar(const std::string &section, const std::string &tagname, const double data) {
     writevar(section, tagname, dbl2str(data));
}

void XOutput::writevar(const std::string &section, const std::string &tagname, const std::string &data) {
     DOMText *newlineend    = doc_->createTextNode(Ch2XML("\n").toXML());
     DOMElement *secelement = getSectionElement(section);
     DOMElement *element    = doc_->createElement(Ch2XML("var").toXML());
     element->setAttribute(Ch2XML("name").toXML(), Ch2XML(tagname).toXML());
     DOMText *textele = doc_->createTextNode(Ch2XML(data).toXML());
     element->appendChild(textele);
     secelement->appendChild(element);
     secelement->appendChild(newlineend);
}

XOutput::~XOutput() {
     doc_->release();
     delete filetarget_;
}
