/******************************************************************************

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

******************************************************************************/

#ifndef CONTROL_H
#define CONTROL_H

#include "node.hpp"
#include "alloc.hpp"
#include "strpool.hpp"
#include "parse.hpp"

#include "type.hpp"

namespace Parse {

     using NodeInfo::Node;

     /**
      * Control structure that keeps track of the root
      * parse node and the current parse position during
      * the parse
      */
     class Control {
     public:
	  Control(const char *s, NodeInfo::Alloc *alc, StrPool &p, int l, int c, const char* name) 
	       : toParse(s)
	       , root(0)
	       , alloc(alc)
	       , begin(c)
	       , end(c)
	       , line(l)
	       , scan_pos(0)
	       , strpool(p)
	       , filename(name) {
	  }

	  const char *pool(const char *s) {
	       return strpool[s];
	  }

	  const char *pool(const char *s, int len) {
	       std::string t(s);
	       return pool(t.substr(0, len).c_str());
	  }

	  const char *toParse;
	  NodeInfo::Node *root;
	  NodeInfo::Alloc *alloc;
	  int begin;
	  int end;
	  int line;
	  int scan_pos;
	  StrPool &strpool;
	  const char* filename;
     };

     Control* getControl();
     void setControl(Control* c);

     using namespace NodeInfo;
     extern Node* Str(const char *s, int lbegin, int lend, int cbegin, int cend);
     extern Node* Str(const char *s, YYLTYPE begin, YYLTYPE end);
     extern Node* Int(int i, YYLTYPE begin, YYLTYPE end);
     extern Node* Dbl(double d, YYLTYPE begin, YYLTYPE end);
     extern Node* TmplRef(int i, YYLTYPE begin, YYLTYPE end);
     extern Node* Bool(bool b, YYLTYPE begin, YYLTYPE end);
     extern Node* Call(const char *s, Node* l, int lbegin, int lend, int cbegin, int cend);
     extern Node* Call(const char *s, Node* l, YYLTYPE begin, YYLTYPE end);
     extern Node* List(Node* h, Node* t);
     extern Node* Line(Node* h, Node* t);
     extern void result(Node* n);
     void reverse_lists(Node *node);
     extern void print_tree(Node* node);
     extern void print_parse(Node* node);
}

#endif
