/******************************************************************************

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

******************************************************************************/

#ifndef ERROR_H
#define ERROR_H

#include <sstream>
#include <string>

#include "node.hpp"

namespace Parse {

     /**
      * Exception class
      */
     class Error {
     public:
	  Error(const char *s)
	       : message(s)
	       , row(0)
	       , column(0) {
	  }

	  Error(const char *s, int l, int c)
	       : message(s) 
	       , row(l)
	       , column(c) {
	  }

	  Error(const char *s, int l, int c, std::string name)
	       : message(s) 
	       , row(l)
	       , column(c)
	       , filename(name) {
	  }

	  Error(const std::string& s, int l, int c, std::string name)
	       : message(s) 
	       , row(l)
	       , column(c)
	       , filename(name) {
	  }

	  Error(const char *s, int l, int c, std::string name, std::string i)
	       : message(s) 
	       , row(l)
	       , column(c)
	       , filename(name)
	       , id(i) {
	  }

	  Error(const char *s, NodeInfo::Node *n)
	       : message(s) 
	       , row(n->lbegin)
	       , column(n->cbegin) 
	       , filename(n->filename) {
	  }

	  Error(const std::string& s, NodeInfo::Node *n)
	       : message(s) 
	       , row(n->lbegin)
	       , column(n->cbegin) 
	       , filename(n->filename) {
	  }

	  const char* what() const throw() {
	       static char buf[1024];
	       std::ostringstream strm;
	       strm << message << " at row " << row << ", column " << column;
	       if (filename.length() > 0) {
		    strm << " in file " << filename;
	       }
	       strm << ".\n";
	       strncpy(buf, strm.str().c_str(), sizeof buf);
	       return buf;
	  }
     public:
	  std::string message;
	  int row;
	  int column;
	  std::string filename;
	  std::string id;
     };
}

#endif
