/******************************************************************************

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

******************************************************************************/

#include <iostream>

#include "testparser.hpp"

using namespace Test;

int main(int argc, char *argv[]) {
     try {
	  // Variables
	  accept("cont:var;");
	  accept("(:(cont:var))$(:var);");
	  reject("inc(cont:)", "E016");
	  reject("$:var;", "E018");
	  reject("(cont:var", "E006");
	  reject("inc(:var: :var);", "E011");

	  // Semi colons
	  reject("inc(cont:var) inc(:var);", "E001");
	  reject("$var;;", "E017");
	  reject("inc(:var; :var);", "E011");
	  reject("inc(:var,; :var);", "E003");

	  // Arguments
	  reject("inc(error);", "E004");

	  // If
	  accept("if ($test == 4711) { print(\"hej\"); }");
	  reject("if ($test == 4711, print(\"hej\"));", "E006");
	  reject("if($test == 4711) { if ($test2 == 4712) { print(:var); } }", "E019");
	  reject("if ( ($test == 4711) ) { print(:var); }");

	  accept("if (true) { print(:var); }");
	  reject("if (true) print(:var); }", "E007");
	  reject("if (true print(:var); }", "E006");
	  reject("if (true { print(:var); }", "E006");
	  reject("if true { print(:var); }", "E004");

	  reject("if (true) { print(:var); hej print(:har); }", "E004");

	  // Misc
	  reject("inc();", "E003");
	  reject("inc(:var));", "E002");
	  reject("++#1$var;");
	  reject("++cont$var++;", "E003");

     }
     catch (const Parse::Error &e) {
	  std::cerr << "\n";
	  std::cerr << "At row " << e.row << ", column " << e.column << ":\n";
	  std::cerr << e.message << "\n\n";
	  return 1;
     }
     catch (...) {
	  std::cerr << "Uncaught exception\n";
	  return 1;
     }

     return 0;
}
