/******************************************************************************

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

******************************************************************************/

#ifndef NODE_H
#define NODE_H

#include <vector>

namespace NodeInfo {
     struct Node;
     typedef std::vector<Node*> NodeVector;
     enum node_t { T_STR, T_INT, T_DBL, T_CALL, T_LIST, T_LINE, T_BOOL, T_TMPLREF };
}

/**
 * A node in the parse tree
 */
struct NodeInfo::Node {
     NodeInfo::node_t type;
     int cbegin;
     int cend;
     int lbegin;
     int lend;
     NodeVector *args;

     union {
	  const char *str;
	  int integer;
	  double dbl;
	  bool boolean;
     } data;

     const char *name;
     const char *filename;
};

#endif
