/******************************************************************************

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

******************************************************************************/

#include "parse.hpp"

ParseResult::ParseResult()
     : alloc(new NodeInfo::Alloc(pool)) {
}

ParseResult::~ParseResult() {
     delete alloc;
}

NodeInfo::Node* ParseResult::parse(const char *s, int line, int column, const char* filename) {
     return Parse::parse(s, alloc, pool, line, column, filename);
}

NodeInfo::Node* ParseResult::parse(const char *s, int line) {
     return parse(s, line, 0, "Unknown file");
}

NodeInfo::Node* ParseResult::parse(const char *s) {
     return parse(s, 0);
}	  

NodeInfo::Node* ParseResult::clone(NodeInfo::Node* node) {
     return alloc->clone_subtree(node);
}

const char* ParseResult::repool(const char* s) {
     return pool[s];
}

void ParseResult::rename_function(NodeInfo::Node* node, const char *name) {
     check_type(node, NodeInfo::T_CALL);
     node->name = pool[name];
}

using Parse::Call;
using Parse::List;

NodeInfo::Node* ParseResult::andCall(NodeInfo::Node* n1, NodeInfo::Node* n2) {
     NodeInfo::Node* l1 = alloc->alloc_list(n1);
     l1->args->push_back(n2);     
     NodeInfo::Node* n = alloc->alloc_call("and", l1, "internal");
     n->lbegin = n1->lbegin;
     n->lend = n2->lend;
     n->cbegin = n1->cbegin;
     n->cend = n2->cend;
     return n;
}

ParseResult* getParseResult() {
     static ParseResult pr;
     return &pr;
}


