/******************************************************************************

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

******************************************************************************/

#ifndef PARSER_H
#define PARSER_H

#include "error.hpp"
#include "node.hpp"
#include "control.hpp"

namespace Parse {
     NodeInfo::Node* parse(const char*, NodeInfo::Alloc*, Parse::StrPool&, int, int, const char*);
}
     
class ParseResult {
public:
     ParseResult();
     ~ParseResult();

     /* Parse functions */
     NodeInfo::Node* parse(const char *s, int line, int column, const char* filename);
     NodeInfo::Node* parse(const char *s, int line);
     NodeInfo::Node* parse(const char *s);

     /* Clones the subtree */
     NodeInfo::Node* clone(NodeInfo::Node* node);

     /* Puts a string in the pool */
     const char* repool(const char* s);

     /* Renames a function call */
     void rename_function(NodeInfo::Node* node, const char *name);

     /* Creates and 'and' call wrapping the two nodes */
     NodeInfo::Node* andCall(NodeInfo::Node* n1, NodeInfo::Node* n2);

     /* Checks if a node is of the expected type
	and throws an exception	otherwise */
     static void check_type(const NodeInfo::Node* node, NodeInfo::node_t type) {
	  if (!node) {
	       throw Parse::Error("Node is NULL!");
	  }
	  if (node->type != type) {
	       std::ostringstream strm;
	       strm << "Node of type ";
	       switch (type) {
	       case NodeInfo::T_STR:     strm << "STR";     break;
	       case NodeInfo::T_INT:     strm << "INT";     break;
	       case NodeInfo::T_DBL:     strm << "DBL";     break;
	       case NodeInfo::T_CALL:    strm << "CALL";    break;
	       case NodeInfo::T_LIST:    strm << "LIST";    break;
	       case NodeInfo::T_LINE:    strm << "LINE";    break;
	       case NodeInfo::T_BOOL:    strm << "BOOL";    break;
	       case NodeInfo::T_TMPLREF: strm << "TMPLREF"; break;
	       default:                  strm << "ERROR";   break;
	       }
	       strm << " expected, but found node of type ";
	       switch (node->type) {
	       case NodeInfo::T_STR:     strm << "STR";     break;
	       case NodeInfo::T_INT:     strm << "INT";     break;
	       case NodeInfo::T_DBL:     strm << "DBL";     break;
	       case NodeInfo::T_CALL:    strm << "CALL";    break;
	       case NodeInfo::T_LIST:    strm << "LIST";    break;
	       case NodeInfo::T_LINE:    strm << "LINE";    break;
	       case NodeInfo::T_BOOL:    strm << "BOOL";    break;
	       case NodeInfo::T_TMPLREF: strm << "TMPLREF"; break;
	       default:                  strm << "ERROR";   break;
	       }
	       throw Parse::Error(strm.str().c_str(), node->lbegin, node->cbegin, node->filename);
	  }
     }
     
protected:
     Parse::StrPool pool;
     NodeInfo::Alloc *alloc;     
};

ParseResult* getParseResult();

#endif
