/******************************************************************************

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

******************************************************************************/

#include "testparser.hpp"

#include <sstream>

namespace Test {

     void accept(const char *str) {
	  try {
	       ParseResult *pr = getParseResult();
	       pr->parse(str);
	  }
	  catch (const Parse::Error &e) {
	       std::ostringstream strm;
	       strm << "PARSER FAILURE: Unsuccessful accept\n";
	       strm << e.message << "\n";
	       throw Parse::Error(strm.str().c_str(), e.row, e.column);
	  }
     }

     void reject(const char *str, bool show) {
	  try {
	       ParseResult *pr = getParseResult();
	       pr->parse(str);
	  }
	  catch (const Parse::Error &e) {
	       if (show) {
		    std::cout << "*****************************************\n";
		    std::cout << str << "\n";
		    for (int i = 0; i < e.column; ++i) std::cout << ' ';
		    std::cout << "^\n";
		    std::cout << "At row " << e.row << ", column " << e.column << ":\n"
			      << e.message << "\n";
		    std::cout << "*****************************************\n";
	       }
	       return;
	  }
	  std::ostringstream strm;
	  strm << "PARSER FAILURE: Unsuccessful reject\n";
	  strm << str << "\n";
	  throw Parse::Error(strm.str().c_str());
     }     

     void reject(const char *str, const char* msg) {
	  try {
	       ParseResult *pr = getParseResult();
	       pr->parse(str);
	  }
	  catch (const Parse::Error &e) {
	       if (e.id != msg) {
		    std::ostringstream strm;
		    strm << "PARSER FAILURE: Wrong reject\n";
		    strm << str << "\n";
		    strm << e.message << "\n";
		    throw Parse::Error(strm.str().c_str(), e.row, e.column);
	       }
	       return;
	  }
	  std::ostringstream strm;
	  strm << "PARSER FAILURE: Unsuccessful reject\n";
	  strm << str << "\n";
	  throw Parse::Error(strm.str().c_str());
     }   
}
