/* inflector.hh
 * author: Johan Carlberger
 * last change: 990921
 * comments: Inflector class
 */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _inflector_hh
#define _inflector_hh

#include "wordlexicon.h"
#include "newwordlexicon.h"
#include "taglexicon.h"

class Inflector {
public:
  Inflector(const char *lexiconDir);
  const char *GetInflectionList(const char*);
  void GenerateForms(const char*, const char *newline = "\n");
  void Interact();
  bool IsLoaded() const { return tags.IsLoaded() && words.IsLoaded(); }
private:
  TagLexicon tags;
  NewWordLexicon newWords;
  WordLexicon words;
};

#endif
