/* main.cc
 * author: Johan Carlberger
 * last change: 051230, minor change, Oscar Tckstrm
 * comments: main for Inflector only
 */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "inflector.h"
#include <iostream>

int PrintUsage(char *progName) {
    std::cerr<<"usage:"<<std::endl
             <<progName<<tab<<"[-l lexiconDir] [-ABJWuvW]"<<std::endl
             <<tab<<"A:"<<dont(xPrintAllWords)<<"print all words"<<std::endl
             <<tab<<"B:"<<dont(xPrintLemma)<<"print lemma"<<std::endl
             <<tab<<"J:"<<dont(xPrintLemma)<<"print word info"<<std::endl
             <<tab<<"M:"<<dont(xPrintLemma)<<"print all word tags"<<std::endl
             <<tab<<"u:"<<dont(xPrintLemma)<<"print analyze new words"<<std::endl
             <<tab<<"v:"<<dont(xVerbose)<<"verbose"<<std::endl
             <<tab<<"W:"<<dont(xWarnAll)<<"warn for all suspicious things"<<std::endl
             <<"if no lexicon directory is given, the program uses the path"<<std::endl
             <<"in environment variable TAGGER_LEXICON = "<<getenv("TAGGER_LEXICON")<<std::endl;
    return 0;
}

int main(int argc, char **argv) {
    xCompoundRequirePrefix = 0;
    const char *lexiconDir = getenv("TAGGER_LEXICON");
    int i;
    for (i=1; i<argc && argv[i][0] == '-'; i++)
        if (argv[i][1] == 'l') {
            if (++i < argc)
                lexiconDir = argv[i];
            else
                return PrintUsage(argv[0]);
        } else for (int j=1; argv[i][j]; j++)
            switch(argv[i][j]) {
            case 'A': neg(xPrintAllWords); break;
            case 'B': neg(xPrintLemma); break;
            case 'J': neg(xPrintWordInfo); break;
            case 'M': neg(xPrintAllWordTags); break;
            case 'u': neg(xAnalyzeNewWords); break;
            case 'v': neg(xVerbose); break;
            case 'W': neg(xWarnAll); break;
            default: return PrintUsage(argv[0]);
            }

    if (!lexiconDir)
        return PrintUsage(argv[0]);
    std::cout.precision(5);
  
    Inflector inflector(lexiconDir);
    inflector.Interact();

    return 0;
}

