//
// = FILENAME
//    MineAgent.java
//
// = FUNCTION
//    This is the AI part of the game. It is supposed figure out what
//    squares to open next and when to stop
//
// = AUTHOR(S)
//    Patric Jensfelt
//
// = COPYRIGHT
//    Copyright (c) 2006 Patric Jensfelt
//
/*----------------------------------------------------------------------*/

/**
 * This is the agent interface that should be overloaded to play
 * MineSweep
 *
 * @author Patric Jensfelt
 * @see
 */
interface MineAgent {
    /**
     * @param numPlayers tells how many players are playing this game
     * @param playerID the id for this player in the game
     * @param xsize number of squares in the horizontal direction
     * @param ysize number of squares in the vertical direction 
     * @param deadCost cost to die
     * @param peekCost the cos to take a peek at a square
     * 
     * @return true if initialization went ok
     */
    public boolean startNewGame(int numPlayers, int playerID,
                                int xsize, int ysize,
                                int deadCost, int peekCost);

    /**
     * @return the move suggested by this agent given the information
     * it has gathered so far
     */
    public MineMove getNextMove();

    /**
     * This function is called by the system after a square is opened,
     * another player has died or stopped playing.
     *
     * @param info information about the game
     */
    public void handleInfo(MineInfo info);
};
