//
// = FILENAME
//    MineInfo.java
//
// = FUNCTION

//    Object that contain information about the game. It comes in a
//    few different forms
//      Info about a certain square
//      Another player stops
// 
// = AUTHOR(S)
//    Patric Jensfelt
//
// = COPYRIGHT
//    Copyright (c) 2006 Patric Jensfelt
//
/*----------------------------------------------------------------------*/


/**
 * This is a but ugly way to wrap all the information that can come
 * from the server
 */
class MineInfo {
    /// Different type of info
    public static int SQUARE_INFO = 1;
    public static int ILLEGAL_MOVE = 2;
    public static int ALREADY_OPEN = 3;
    public static int PLAYER_STOPPED = 4;
    public static int UNKNOWN_CMD = 5;
    public static int SCORE = 6;
    public static int ALREADY_PEEKED = 7;

    /// The type of info SQUARE_INFO, PLAYER_STOPS, etc
    public int m_InfoType;

    /// This variable gives the ID of the player that resulted in this
    /// info by opening a square or stopping
    public int m_PlayerID;

    /// Specifies what square
    public int m_X;
    public int m_Y;

    /// 0-8 for number of mines around,
    /// -1  for mine that just killed you
    /// -2  for mine that occured before the game started and thus does
    ///     not kill you
    /// -10 square outside mine filed
    public int m_Value;  

    /// The Score in case of a SCORE message
    public int m_Score;

    public String m_UnknownCmd;
};
