//
// = FILENAME
//    StatWindow.java
//
// = FUNCTION
//
// = AUTHOR(S)
//    Patric Jensfelt
//
// = COPYRIGHT
//    Copyright (c) 2006 Patric Jensfelt
//
/*----------------------------------------------------------------------*/

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

/**
 * Shows the statistics from minesweep
 *
 * @author Patric Jensfelt
 * @see
 */
class StatWindow extends JFrame implements ActionListener {
    private Minesweep m_Parent;

    private JTextField m_TeamName1 = null;
    private JTextField m_TeamName2 = null;

    private int m_NumGames;
    private JTextField m_NumGamesText = null;
    int m_NumWins1, m_NumWins2;
    private JTextField m_NumWins1Text = null;
    private JTextField m_NumWins2Text = null;
    double m_AvgFrac1, m_AvgFrac2;
    private JTextField m_AvgFrac1Text = null;
    private JTextField m_AvgFrac2Text = null;
    private JTextField m_TimeText = null;
    private JTextField m_MaxTimeText = null;
    
    public StatWindow(Minesweep parent) {
        setTitle("Statistics");
        setLayout(new BorderLayout());

        m_Parent = parent;

        JPanel stats = new JPanel();
        stats.setLayout(new GridLayout(6,3));

        JLabel jl;

        jl = new JLabel(""); stats.add(jl);
        jl = new JLabel("Player1"); stats.add(jl);
        jl = new JLabel("Player2"); stats.add(jl);
        
        jl = new JLabel("Name"); stats.add(jl);
        m_TeamName1 = new JTextField("Player1"); stats.add(m_TeamName1);
        m_TeamName2 = new JTextField("Player2"); stats.add(m_TeamName2);
        
        jl = new JLabel("#wins"); stats.add(jl);
        m_NumWins1Text = new JTextField("0"); stats.add(m_NumWins1Text);
        m_NumWins1Text.setEditable(false);
        m_NumWins2Text = new JTextField("0"); stats.add(m_NumWins2Text);
        m_NumWins2Text.setEditable(false);

        jl = new JLabel("avg %"); stats.add(jl);
        m_AvgFrac1Text = new JTextField("0"); stats.add(m_AvgFrac1Text);
        m_AvgFrac1Text.setEditable(false);
        m_AvgFrac2Text = new JTextField("0"); stats.add(m_AvgFrac2Text);
        m_AvgFrac2Text.setEditable(false);

        stats.add(new JLabel("#games"));
        m_NumGamesText = new JTextField("0");
        m_NumGamesText.setEditable(false);
        stats.add(m_NumGamesText);
        stats.add(new JLabel(""));

        stats.add(new JLabel("Time"));
        m_TimeText = new JTextField("0s"); stats.add(m_TimeText);
        m_TimeText.setEditable(false);
        m_MaxTimeText = new JTextField("300s"); stats.add(m_MaxTimeText);
        m_MaxTimeText.setEditable(false);

        add(stats, BorderLayout.NORTH);
        JButton but = new JButton("Stop");
        but.addActionListener(this);
        add(but, BorderLayout.SOUTH);

        //clearStats();

        pack();
    }

    public void actionPerformed(ActionEvent e) {
        if ("Stop".equals(e.getActionCommand())) {
            System.out.println("Stopping game");
            m_Parent.stopGame();
        } else {
            System.out.println("Not trapping cmd \"" + 
                               e.getActionCommand() + "\"");
        }
    }

    public void setTeamName(String name1, String name2)
    {
        m_TeamName1.setText(name1);
        m_TeamName2.setText(name2);
    }

    public void setTime(long time, long maxTime) {
        m_TimeText.setText("" + time + "s");
        m_MaxTimeText.setText("" + maxTime + "s");
    }

    protected void updateTexts() {
        m_NumGamesText.setText("" + m_NumGames);
        m_NumWins1Text.setText("" + m_NumWins1);
        m_NumWins2Text.setText("" + m_NumWins2);
        m_AvgFrac1Text.setText("" + (long)(100.0 * m_AvgFrac1));
        m_AvgFrac2Text.setText("" + (long)(100.0 * m_AvgFrac2));
    }

    public void clearStats() {
        m_NumGames = 0;
        m_NumWins1 = 0;
        m_NumWins2 = 0;
        m_AvgFrac1 = 0;
        m_AvgFrac2 = 0;
        updateTexts();
    }

    public void addStats(double frac1, boolean win1,
                         double frac2, boolean win2) {
        m_AvgFrac1 = (m_AvgFrac1 * m_NumGames + frac1) / (m_NumGames + 1);
        m_AvgFrac2 = (m_AvgFrac2 * m_NumGames + frac2) / (m_NumGames + 1);
        if (win1) m_NumWins1++;
        if (win2) m_NumWins2++;
        m_NumGames++;

        System.out.println("Adding more statistics " +
                           frac1 + " " + win1 + " " +
                           frac2 + " " + win2 + " #games=" + m_NumGames);

        updateTexts();
    }
};

