//
// = FILENAME
//    Batchsweep.java
//
// = FUNCTION
//    Executable class that runs through a batch file
//    once with the agent(s) that connect.
// 
// = AUTHOR(S)
//    Oscar Sundbom
//
// = COPYRIGHT
//    Copyright (c) 2007 Oscar Sundbom
//
/*----------------------------------------------------------------------*/


public class Batchsweep implements MinesweepUI {

	private MinesweepEngine m_Engine;

    public Batchsweep(MinesweepEngine engine) {
    	m_Engine = engine;
    	m_Engine.setUI(this);
    	m_Engine.setPlayMode(MinesweepEngine.SERVER_MODE);
        m_Engine.newGame();
    }

    public static void main(String[] args) {

        int port = 5555;
        if(args.length == 0) {
        	System.out.println("You must specify a batch file\n" +
        						"args: <Batchfile> [Port] [NumPlayers]");
        	System.exit(0);
        }
        
        if (args.length >= 2) {
            try {
                port = Integer.parseInt(args[1]);
            } catch (Exception e) {
                System.out.println("Could not get port number for server\n" +
                		"args: <Batchfile> [Port] [NumPlayers]");
                System.exit(0);
            }
        }

        int numplayers = 1;
        if (args.length >= 3) {
            try {
                numplayers = Integer.parseInt(args[2]);
                if (numplayers < 1 || numplayers > 2) {
                    System.out.println("Only allowing 1 or 2 player\n" +
                    					"args: <Batchfile> [Port] [NumPlayers]");
                    System.exit(0);
                }
            } catch (Exception e) {
                System.out.println("Could not get number of players\n" +
                					"args: <Batchfile> [Port] [NumPlayers]");
                System.exit(0);
            }
        }

        // Initialize the engine with arbitrary parameters
        MinesweepEngine engine = new MinesweepEngine(port, 10, 10, 0.1, 10, 1);
        engine.setTwoPlayerGame((numplayers==2));

        Batchsweep sweeper = new Batchsweep(engine);
        
        // Wait for players
        System.out.println("Waiting for players...");
        while(true) {
        	try {
        		if(engine.getNumClients() == numplayers) 
        			break;
        		
        		Thread.sleep(1000);
        	} catch(InterruptedException ex) {
        		System.exit(0);
        	}
        }
    
        System.out.println("All players are here. Starting!");
        engine.runBatchFileTest(args[0]);
    }

	public void batchRunEnded() {
		// Finish
		System.exit(0);
	}

	public void showMessage(String msg, int level) {
		if(level <= LEVEL_ERROR) {
			System.out.println(msg);
		}
	}
};

