//
// = FILENAME
//    MineClient.java
//
// = FUNCTION
//
// = AUTHOR(S)
//    Patric Jensfelt
//
// = COPYRIGHT
//    Copyright (c) 2006 Patric Jensfelt
//
/*----------------------------------------------------------------------*/

import java.io.*;
import java.net.*;

public class MineClient {
    private Socket m_Socket = null;
    private String m_Hostname = "localhost";
    private int m_Port = 5555;
    private MineAgent m_Agent = null;

    protected boolean connect(String hostname, int port) {
        System.out.println("Trying to connect to " + hostname +
                           " on port " + port);
        try {
            m_Socket = new Socket(hostname, port);
            System.out.println("Opened connection to " + hostname + 
                               " on port " + port);
            return true;

        } catch (UnknownHostException e) {
            System.err.println("Don't know about host: " + hostname);
        } catch (IOException e) {
            System.err.println("Couldn't get I/O for "
                               + "the connection to: " + hostname);
        }
        
        // We failed and 
        m_Socket = null;
        return false;
    }
    
    protected boolean disconnect() {
        if (m_Socket == null) return true;

        System.out.println("Closing connection to server");

        try {
            m_Socket.close();
        } catch (Exception e) {
            System.err.println("Got exception when closing socket");
        }

        m_Socket = null;
        return true;
    }

    protected void playGame(String name)
    {
        if (!this.connect(m_Hostname, m_Port)) return;
        
        BufferedReader in = null;
        PrintWriter out = null;

        try {
            InputStreamReader tmp = 
                new InputStreamReader(m_Socket.getInputStream());
            in = new BufferedReader(tmp);
            out = new PrintWriter(m_Socket.getOutputStream(),true);
        } catch (Exception exc) {
            System.out.println("Failed to set up comm with Minsweep server");
            return;
        }

        // Send name of agent
        out.println(name);

        while (true) {
            
            try {
                String msg = in.readLine();
                if (msg != null) {
                    System.out.println("msg=\"" + msg + "\"");
                    if (msg.equals("MOVE")) {
                        MineMove mm = m_Agent.getNextMove();
                        if (mm != null) {
                            if (mm.m_Move == MineMove.OPEN_SQUARE) {
                                out.println("OPEN " + mm.m_X + " " +
                                            mm.m_Y);
                            } else if (mm.m_Move == MineMove.PEEK_SQUARE) {
                                out.println("PEEK " + mm.m_X + " " +
                                            mm.m_Y);
                            } else if (mm.m_Move == MineMove.STOP) {
                                out.println("STOP");
                            } else {
                                System.out.println("Unexpected command " +
                                                   mm.m_Move + "!!!!!");
                                continue;
                            }
                        } else {
                            System.out.println("Could not get agent move");
                            continue;
                        }
                    } else if (msg.startsWith("START")) {

                        String cmd[] = msg.split(" ");
                        if (cmd != null && cmd.length == 7) {
                            m_Agent.startNewGame(Integer.parseInt(cmd[1]),
                                                 Integer.parseInt(cmd[2]),
                                                 Integer.parseInt(cmd[3]),
                                                 Integer.parseInt(cmd[4]),
                                                 Integer.parseInt(cmd[5]),
                                                 Integer.parseInt(cmd[6]));
                        }
                    } else if (msg.startsWith("SQUARE_INFO")) {
                        String cmd[] = msg.split(" ");
                        if (cmd != null && cmd.length == 5) {
                            MineInfo mi = new MineInfo();
                            mi.m_InfoType = MineInfo.SQUARE_INFO;
                            mi.m_PlayerID = Integer.parseInt(cmd[1]);
                            mi.m_X = Integer.parseInt(cmd[2]);
                            mi.m_Y = Integer.parseInt(cmd[3]);
                            mi.m_Value = Integer.parseInt(cmd[4]);
                            m_Agent.handleInfo(mi);
                        }
                    } else if (msg.startsWith("ILLEGAL_MOVE")) {
                        String cmd[] = msg.split(" ");
                        if (cmd != null && cmd.length == 4) {
                            MineInfo mi = new MineInfo();
                            mi.m_InfoType = MineInfo.ILLEGAL_MOVE;
                            mi.m_PlayerID = Integer.parseInt(cmd[1]);
                            mi.m_X = Integer.parseInt(cmd[2]);
                            mi.m_Y = Integer.parseInt(cmd[3]);
                            m_Agent.handleInfo(mi);
                        }
                    } else if (msg.startsWith("ALREADY_OPEN")) {
                        String cmd[] = msg.split(" ");
                        if (cmd != null && cmd.length == 4) {
                            MineInfo mi = new MineInfo();
                            mi.m_InfoType = MineInfo.ALREADY_OPEN;
                            mi.m_PlayerID = Integer.parseInt(cmd[1]);
                            mi.m_X = Integer.parseInt(cmd[2]);
                            mi.m_Y = Integer.parseInt(cmd[3]);
                            m_Agent.handleInfo(mi);
                        }
                    } else if (msg.startsWith("ALREADY_PEEKED")) {
                        String cmd[] = msg.split(" ");
                        if (cmd != null && cmd.length == 2) {
                            MineInfo mi = new MineInfo();
                            mi.m_InfoType = MineInfo.ALREADY_PEEKED;
                            mi.m_PlayerID = Integer.parseInt(cmd[1]);
                            m_Agent.handleInfo(mi);
                        }
                    } else if (msg.startsWith("PLAYER_STOPPED")) {
                        String cmd[] = msg.split(" ");
                        if (cmd != null && cmd.length == 2) {
                            MineInfo mi = new MineInfo();
                            mi.m_InfoType = MineInfo.PLAYER_STOPPED;
                            mi.m_PlayerID = Integer.parseInt(cmd[1]);
                            m_Agent.handleInfo(mi);
                        }
                    } else if (msg.startsWith("UNKNOWN_CMD")) {
                        MineInfo mi = new MineInfo();
                        mi.m_InfoType = MineInfo.UNKNOWN_CMD;
                        mi.m_UnknownCmd = msg.substring(12, msg.length());
                        m_Agent.handleInfo(mi);
                    } else if (msg.startsWith("DONE")) {
                        String cmd[] = msg.split(" ");
                        if (cmd != null && cmd.length == 2) {
                            MineInfo mi = new MineInfo();
                            mi.m_InfoType = MineInfo.SCORE;
                            mi.m_Score = Integer.parseInt(cmd[1]);
                            m_Agent.handleInfo(mi);
                        }
                    }
                }
            } catch (Exception exc) {
                System.out.println("Got exception, exiting!");
                return;
            }
        }
    }

    public static void main(String args[]) {

        MineClient mc = new MineClient();

        // Change this line so that it includes your agent instead
        mc.m_Agent = new StupidAgent();

        if (args.length >= 1) {
            mc.m_Hostname = args[0];
        }

        if (args.length >= 2) {
            try {
                mc.m_Port = Integer.parseInt(args[1]);
            } catch (Exception e) {
                System.out.println("Could not parse port to connect to\n" +
                                   "Args: <hostname> <port> <agent name>");
                System.exit(0);
            }
        }

        if (args.length > 2) {
            mc.playGame(args[2]);
        } else {
            mc.playGame("StupidAgent");
        }
    }
}
 

